/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.template.topplayernumber.manager;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import me.hsgamer.topper.agent.snapshot.SnapshotAgent;
import me.hsgamer.topper.query.core.QueryManager;
import me.hsgamer.topper.query.holder.HolderQuery;
import me.hsgamer.topper.query.simple.SimpleQueryDisplay;
import me.hsgamer.topper.query.snapshot.SnapshotQuery;
import me.hsgamer.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.template.topplayernumber.holder.NumberTopHolder;
import org.jetbrains.annotations.NotNull;

public class TopQueryManager
extends QueryManager<UUID> {
    public TopQueryManager(final TopPlayerNumberTemplate template) {
        this.addQuery((BiFunction)new HolderQuery<UUID, Double, NumberTopHolder, UUID>(){

            protected Optional<NumberTopHolder> getHolder(@NotNull String name) {
                return template.getTopManager().getHolder(name);
            }

            @NotNull
            protected SimpleQueryDisplay<UUID, Double> getDisplay(@NotNull NumberTopHolder holder) {
                return holder.getValueDisplay();
            }

            protected Optional<UUID> getKey(@NotNull UUID actor, @NotNull HolderQuery.Context<UUID, Double, NumberTopHolder> context) {
                return Optional.of(actor);
            }
        });
        this.addQuery((BiFunction)new SnapshotQuery<UUID, Double, UUID>(){

            protected Optional<SnapshotAgent<UUID, Double>> getAgent(@NotNull String name) {
                return template.getTopManager().getHolder(name).map(NumberTopHolder::getSnapshotAgent);
            }

            protected Optional<SimpleQueryDisplay<UUID, Double>> getDisplay(@NotNull String name) {
                return template.getTopManager().getHolder(name).map(NumberTopHolder::getValueDisplay);
            }

            protected Optional<UUID> getKey(@NotNull UUID actor, @NotNull SnapshotQuery.Context<UUID, Double> context) {
                return Optional.of(actor);
            }

            @NotNull
            protected String getDisplayRank(int rank, @NotNull SnapshotQuery.Context<UUID, Double> context) {
                return context.display.getDisplayValue((Object)rank, context.parent.args);
            }
        });
    }
}

