/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.value.core;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueWrapper<T> {
    @NotNull
    public final State state;
    @Nullable
    public final T value;
    @NotNull
    public final String errorMessage;
    @Nullable
    public final Throwable throwable;

    public ValueWrapper(@NotNull State state, @Nullable T value, @NotNull String errorMessage, @Nullable Throwable throwable) {
        this.state = state;
        this.value = value;
        this.errorMessage = errorMessage;
        this.throwable = throwable;
    }

    public static <T> ValueWrapper<T> handled(@Nullable T value) {
        return new ValueWrapper<T>(State.HANDLED, value, "", null);
    }

    public static <T> ValueWrapper<T> notHandled() {
        return new ValueWrapper<Object>(State.NOT_HANDLED, null, "", null);
    }

    public static <T> ValueWrapper<T> error(@NotNull String errorMessage) {
        return new ValueWrapper<Object>(State.ERROR, null, errorMessage, null);
    }

    public static <T> ValueWrapper<T> error(@NotNull Throwable throwable) {
        return new ValueWrapper<Object>(State.ERROR, null, Optional.ofNullable(throwable.getMessage()).orElse("There is an error when handling the value"), throwable);
    }

    public static <T> ValueWrapper<T> error(@NotNull String errorMessage, @NotNull Throwable throwable) {
        return new ValueWrapper<Object>(State.ERROR, null, errorMessage, throwable);
    }

    public static <T> ValueWrapper<T> copyNullWrapper(@NotNull ValueWrapper<?> wrapper) {
        return new ValueWrapper<Object>(wrapper.state, null, wrapper.errorMessage, wrapper.throwable);
    }

    public boolean isHandled() {
        return this.state == State.HANDLED;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public Optional<T> asOptional(BiConsumer<@NotNull String, @Nullable Throwable> errorConsumer) {
        switch (this.state) {
            case HANDLED: {
                return Optional.ofNullable(this.value);
            }
            case ERROR: {
                errorConsumer.accept(this.errorMessage, this.throwable);
            }
        }
        return Optional.empty();
    }

    public static enum State {
        HANDLED,
        ERROR,
        NOT_HANDLED;

    }
}

