/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.value.core;

import java.util.function.Function;
import me.hsgamer.topper.value.core.ValueWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueProvider<K, V>
extends Function<K, ValueWrapper<V>> {
    public static <K, V> ValueProvider<K, V> empty() {
        return k -> ValueWrapper.notHandled();
    }

    public static <K, V> ValueProvider<K, V> ofSimple(Function<@NotNull K, @Nullable V> function) {
        return k -> {
            try {
                return ValueWrapper.handled(function.apply(k));
            }
            catch (Throwable e) {
                return ValueWrapper.error("An error occurred while getting the value", e);
            }
        };
    }

    @Override
    @NotNull
    public ValueWrapper<V> apply(@NotNull K var1);

    default public <RK> ValueProvider<RK, V> keyMapper(Function<@NotNull RK, @Nullable K> mapper) {
        return rawKey -> {
            try {
                Object key = mapper.apply(rawKey);
                if (key == null) {
                    return ValueWrapper.notHandled();
                }
                return this.apply(key);
            }
            catch (Throwable e) {
                return ValueWrapper.error("An error occurred while mapping the key", e);
            }
        };
    }

    default public <F> ValueProvider<K, F> thenApply(Function<@NotNull V, @Nullable F> mapper) {
        return key -> {
            Object wrapper = this.apply(key);
            if (!((ValueWrapper)wrapper).isHandled()) {
                return ValueWrapper.copyNullWrapper(wrapper);
            }
            if (((ValueWrapper)wrapper).value == null) {
                return ValueWrapper.error("The raw value is null");
            }
            try {
                return ValueWrapper.handled(mapper.apply(((ValueWrapper)wrapper).value));
            }
            catch (Throwable e) {
                return ValueWrapper.error("An error occurred while converting the raw value", e);
            }
        };
    }
}

