/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramProvider;
import me.hsgamer.unihologram.common.hologram.NoneHologram;
import me.hsgamer.unihologram.common.provider.LocalHologramProvider;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SpigotHologramProvider
implements HologramProvider<Location> {
    private final HologramProvider<Location> provider;

    public SpigotHologramProvider(Plugin plugin) {
        this.provider = SpigotHologramProvider.getDefaultProviderOrNone(plugin);
    }

    public SpigotHologramProvider() {
        this((Plugin)JavaPlugin.getProvidingPlugin(SpigotHologramProvider.class));
    }

    private static boolean checkClassDependAvailable(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("isAvailable", new Class[0]);
            if (!method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class)) {
                return false;
            }
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return true;
        }
    }

    private static Optional<HologramProvider<Location>> getProvider(Plugin plugin, String className) {
        HologramProvider provider;
        boolean hasPluginConstructor;
        Constructor<?> constructor;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
            if (!HologramProvider.class.isAssignableFrom(clazz)) {
                return Optional.empty();
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return Optional.empty();
        }
        if (!SpigotHologramProvider.checkClassDependAvailable(clazz)) {
            return Optional.empty();
        }
        try {
            constructor = clazz.getConstructor(Plugin.class);
            hasPluginConstructor = true;
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = clazz.getConstructor(new Class[0]);
                hasPluginConstructor = false;
            }
            catch (NoSuchMethodException ex) {
                return Optional.empty();
            }
        }
        try {
            provider = hasPluginConstructor ? (HologramProvider)constructor.newInstance(plugin) : (HologramProvider)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
        return Optional.of(provider);
    }

    private static HologramProvider<Location> getDefaultProviderOrNone(Plugin plugin) {
        String[] classNames;
        for (String className : classNames = new String[]{"me.hsgamer.unihologram.spigot.decentholograms.provider.DHHologramProvider", "me.hsgamer.unihologram.spigot.holographicdisplays.provider.HDHologramProvider", "me.hsgamer.unihologram.spigot.fancyholograms.provider.FHHologramProvider", "me.hsgamer.unihologram.spigot.cmi.provider.CMIHologramProvider", "me.hsgamer.unihologram.spigot.folia.provider.FoliaHologramProvider", "me.hsgamer.unihologram.spigot.vanilla.provider.VanillaHologramProvider"}) {
            Optional<HologramProvider<Location>> optional = SpigotHologramProvider.getProvider(plugin, className);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return new LocalHologramProvider<Location>(){

            @NotNull
            protected Hologram<Location> newHologram(@NotNull String name, @NotNull Location location) {
                return new NoneHologram(name, (Object)location);
            }
        };
    }

    @NotNull
    public HologramProvider<Location> getProvider() {
        return this.provider;
    }

    @NotNull
    public Hologram<Location> createHologram(@NotNull String name, @NotNull Location location) {
        return this.provider.createHologram(name, (Object)location);
    }

    public Optional<Hologram<Location>> getHologram(@NotNull String name) {
        return this.provider.getHologram(name);
    }

    public Collection<Hologram<Location>> getAllHolograms() {
        return this.provider.getAllHolograms();
    }

    public boolean isLocal() {
        return this.provider.isLocal();
    }
}

