/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.cmi.hologram;

import com.Zrips.CMI.CMI;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class CMIHologram
implements Hologram<Location> {
    private final Supplier<com.Zrips.CMI.Modules.Holograms.CMIHologram> hologramSupplier;
    private final String name;
    private com.Zrips.CMI.Modules.Holograms.CMIHologram hologram;

    public CMIHologram(String name, Location location) {
        this.name = name;
        this.hologramSupplier = () -> {
            com.Zrips.CMI.Modules.Holograms.CMIHologram hologram = new com.Zrips.CMI.Modules.Holograms.CMIHologram(name, location);
            CMI.getInstance().getHologramManager().addHologram(hologram);
            hologram.update();
            return hologram;
        };
    }

    public CMIHologram(com.Zrips.CMI.Modules.Holograms.CMIHologram hologram) {
        this(hologram.getName(), hologram.getCenterLocation());
        this.hologram = hologram;
    }

    private void checkHologramInitialized() {
        Preconditions.checkNotNull((Object)this.hologram, (Object)"Hologram is not initialized");
    }

    @NotNull
    public List<HologramLine> getLines() {
        this.checkHologramInitialized();
        return this.hologram.getLines().stream().map(TextHologramLine::new).collect(Collectors.toList());
    }

    public void setLines(@NotNull List<HologramLine> lines) {
        this.checkHologramInitialized();
        this.hologram.setLines(lines.stream().map(HologramLine::getRawContent).collect(Collectors.toList()));
        this.hologram.refresh();
    }

    public void addLine(@NotNull HologramLine line) {
        this.checkHologramInitialized();
        this.hologram.addLine(line.getRawContent());
        this.hologram.refresh();
    }

    public void setLine(int index, @NotNull HologramLine line) {
        this.checkHologramInitialized();
        this.hologram.setLine(index, line.getRawContent());
        this.hologram.refresh();
    }

    public void insertLine(int index, @NotNull HologramLine line) {
        this.checkHologramInitialized();
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>(this.getLines());
        lines.add(index, line);
        this.setLines(lines);
    }

    public void removeLine(int index) {
        this.checkHologramInitialized();
        this.hologram.removeLine(index);
        this.hologram.refresh();
    }

    public String getName() {
        return this.name;
    }

    public void init() {
        this.hologram = this.hologramSupplier.get();
    }

    public void clear() {
        if (this.hologram != null) {
            this.hologram.remove();
            this.hologram = null;
        }
    }

    public boolean isInitialized() {
        return this.hologram != null;
    }

    public Location getLocation() {
        return this.hologram.getCenterLocation();
    }

    public void setLocation(Location location) {
        this.checkHologramInitialized();
        this.hologram.setLoc(location);
        this.hologram.refresh();
    }
}

