/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.decentholograms.hologram;

import com.google.common.base.Preconditions;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.CommonSpigotHologram;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import me.hsgamer.unihologram.spigot.common.line.SkullHologramLine;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DHHologram
implements CommonSpigotHologram {
    private static final boolean IS_FLAT;
    private final Supplier<Hologram> hologramSupplier = () -> DHAPI.createHologram((String)name, (Location)location);
    private Hologram hologram;

    public DHHologram(String name, Location location) {
    }

    private void checkHologramInitialized() {
        Preconditions.checkNotNull((Object)this.hologram, (Object)"Hologram is not initialized");
    }

    private String toDHContent(HologramLine<?> line) {
        if (line instanceof ItemHologramLine) {
            return "#ICON:" + HologramItem.fromItemStack((ItemStack)((ItemStack)((ItemHologramLine)line).getContent())).getContent();
        }
        if (line instanceof SkullHologramLine) {
            String lineContent = (String)((SkullHologramLine)line).getContent();
            boolean smallHead = Optional.ofNullable(line.getSettings().get("small-head")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
            return "#" + (smallHead ? "SMALLHEAD" : "HEAD") + ": " + (IS_FLAT ? "PLAYER_HEAD" : "SKULL_ITEM") + " (" + lineContent + ")";
        }
        if (line instanceof TextHologramLine) {
            return (String)((TextHologramLine)line).getContent();
        }
        return line.getRawContent();
    }

    @NotNull
    public List<HologramLine<?>> getLines() {
        this.checkHologramInitialized();
        HologramPage page = this.hologram.getPage(0);
        if (page == null) {
            return Collections.emptyList();
        }
        return page.getLines().stream().map(line -> {
            switch (line.getType()) {
                case ICON: {
                    return new ItemHologramLine(line.getItem().parse());
                }
                case SMALLHEAD: 
                case HEAD: {
                    return new SkullHologramLine(line.getItem().getExtras());
                }
            }
            return new TextHologramLine(line.getContent());
        }).collect(Collectors.toList());
    }

    public void setLines(@NotNull List<HologramLine<?>> lines) {
        this.checkHologramInitialized();
        List content = lines.stream().map(this::toDHContent).collect(Collectors.toList());
        DHAPI.setHologramLines((Hologram)this.hologram, content);
    }

    public void addLine(@NotNull HologramLine<?> line) {
        this.checkHologramInitialized();
        DHAPI.addHologramLine((Hologram)this.hologram, (String)this.toDHContent(line));
    }

    public void setLine(int index, @NotNull HologramLine<?> line) {
        this.checkHologramInitialized();
        DHAPI.setHologramLine((Hologram)this.hologram, (int)index, (String)this.toDHContent(line));
    }

    public void removeLine(int index) {
        DHAPI.removeHologramLine((Hologram)this.hologram, (int)index);
    }

    public String getName() {
        return this.hologram.getName();
    }

    public void init() {
        this.hologram = this.hologramSupplier.get();
    }

    public void clear() {
        try {
            if (this.hologram != null) {
                this.hologram.delete();
                this.hologram = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Location getLocation() {
        this.checkHologramInitialized();
        return this.hologram.getLocation();
    }

    public void setLocation(Location location) {
        this.checkHologramInitialized();
        DHAPI.moveHologram((Hologram)this.hologram, (Location)location);
    }

    static {
        boolean isFlat = false;
        try {
            Class.forName("org.bukkit.block.data.BlockData");
            isFlat = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_FLAT = isFlat;
    }
}

