/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.decentholograms.hologram;

import com.google.common.base.Preconditions;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.hsgamer.unihologram.common.api.PagedHologram;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.hologram.extra.PlayerPage;
import me.hsgamer.unihologram.spigot.common.hologram.extra.PlayerVisibility;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import me.hsgamer.unihologram.spigot.common.line.SkullHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DHHologram
implements PagedHologram<Location>,
PlayerPage,
PlayerVisibility,
Colored {
    private static final boolean IS_FLAT;
    private final Supplier<Hologram> hologramSupplier;
    private final String name;
    private Hologram hologram;

    public DHHologram(String name, Location location) {
        this.name = name;
        this.hologramSupplier = () -> DHAPI.createHologram((String)name, (Location)location);
    }

    public DHHologram(Hologram hologram) {
        this(hologram.getName(), hologram.getLocation().clone());
        this.hologram = hologram;
    }

    private void checkHologramInitialized() {
        Preconditions.checkNotNull((Object)this.hologram, (Object)"Hologram is not initialized");
    }

    private String toDHContent(me.hsgamer.unihologram.common.api.HologramLine line) {
        if (line instanceof ItemHologramLine) {
            return "#ICON:" + HologramItem.fromItemStack((ItemStack)((ItemStack)((ItemHologramLine)line).getContent())).getContent();
        }
        if (line instanceof SkullHologramLine) {
            String lineContent = (String)((SkullHologramLine)line).getContent();
            boolean smallHead = Optional.ofNullable(line.getSettings().get("small-head")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
            return "#" + (smallHead ? "SMALLHEAD" : "HEAD") + ": " + (IS_FLAT ? "PLAYER_HEAD" : "SKULL_ITEM") + " (" + lineContent + ")";
        }
        if (line instanceof TextHologramLine) {
            return (String)((TextHologramLine)line).getContent();
        }
        return line.getRawContent();
    }

    private me.hsgamer.unihologram.common.api.HologramLine fromDHLine(HologramLine line) {
        switch (line.getType()) {
            case ICON: {
                return new ItemHologramLine(line.getItem().parse());
            }
            case SMALLHEAD: 
            case HEAD: {
                return new SkullHologramLine(line.getItem().getExtras());
            }
        }
        return new TextHologramLine(line.getContent());
    }

    public int getPages() {
        this.checkHologramInitialized();
        return this.hologram.getPages().size();
    }

    @NotNull
    public List<me.hsgamer.unihologram.common.api.HologramLine> getLines(int page) {
        this.checkHologramInitialized();
        HologramPage hologramPage = this.hologram.getPage(page);
        if (hologramPage == null) {
            return Collections.emptyList();
        }
        return hologramPage.getLines().stream().map(this::fromDHLine).collect(Collectors.toList());
    }

    public void setLines(int page, @NotNull List<me.hsgamer.unihologram.common.api.HologramLine> lines) {
        this.checkHologramInitialized();
        List content = lines.stream().map(this::toDHContent).collect(Collectors.toList());
        DHAPI.setHologramLines((Hologram)this.hologram, (int)page, content);
    }

    public void addLine(int page, @NotNull me.hsgamer.unihologram.common.api.HologramLine line) {
        this.checkHologramInitialized();
        DHAPI.addHologramLine((Hologram)this.hologram, (int)page, (String)this.toDHContent(line));
    }

    public void insertLine(int page, int index, @NotNull me.hsgamer.unihologram.common.api.HologramLine line) {
        this.checkHologramInitialized();
        DHAPI.insertHologramLine((Hologram)this.hologram, (int)page, (int)index, (String)this.toDHContent(line));
    }

    public void setLine(int page, int index, @NotNull me.hsgamer.unihologram.common.api.HologramLine line) {
        this.checkHologramInitialized();
        DHAPI.setHologramLine((Hologram)this.hologram, (int)page, (int)index, (String)this.toDHContent(line));
    }

    public void removeLine(int page, int index) {
        this.checkHologramInitialized();
        DHAPI.removeHologramLine((Hologram)this.hologram, (int)page, (int)index);
    }

    public Optional<me.hsgamer.unihologram.common.api.HologramLine> getLine(int page, int index) {
        this.checkHologramInitialized();
        HologramPage hologramPage = this.hologram.getPage(page);
        if (hologramPage == null) {
            return Optional.empty();
        }
        HologramLine line = hologramPage.getLine(index);
        if (line == null) {
            return Optional.empty();
        }
        return Optional.of(this.fromDHLine(line));
    }

    public String getName() {
        return this.name;
    }

    public void init() {
        this.hologram = this.hologramSupplier.get();
    }

    public void clear() {
        try {
            if (this.hologram != null) {
                this.hologram.delete();
                this.hologram = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return this.hologram != null;
    }

    public Location getLocation() {
        this.checkHologramInitialized();
        return this.hologram.getLocation();
    }

    public void setLocation(Location location) {
        this.checkHologramInitialized();
        DHAPI.moveHologram((Hologram)this.hologram, (Location)location);
    }

    public boolean isVisible(Player viewer) {
        this.checkHologramInitialized();
        return this.hologram.isVisible(viewer);
    }

    public void showAll() {
        this.checkHologramInitialized();
        this.hologram.showAll();
    }

    public void hideAll() {
        this.checkHologramInitialized();
        this.hologram.hideAll();
    }

    public void showTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.show(viewer, this.getFirstPage());
    }

    public void hideTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.hide(viewer);
    }

    public void setPage(Player viewer, int page) {
        this.checkHologramInitialized();
        int pages = this.hologram.getPages().size();
        int actualPage = page;
        if (page < 0) {
            actualPage = pages - 1;
        } else if (page >= pages) {
            actualPage = 0;
        }
        this.hologram.show(viewer, actualPage);
    }

    public int getPage(Player viewer) {
        this.checkHologramInitialized();
        return this.hologram.getPlayerPage(viewer);
    }

    static {
        boolean isFlat = false;
        try {
            Class.forName("org.bukkit.block.data.BlockData");
            isFlat = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_FLAT = isFlat;
    }
}

