/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.fancyholograms.hologram;

import com.google.common.base.Preconditions;
import de.oliver.fancyholograms.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.PlayerVisibility;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class FHHologram
implements Hologram<Location>,
PlayerVisibility {
    private static final double LINE_HEIGHT = 0.25;
    private final de.oliver.fancyholograms.api.Hologram hologram;

    public FHHologram(String name, Location location) {
        HologramData data = new HologramData(name);
        data.setLocation(location);
        this.hologram = FancyHologramsPlugin.get().getHologramsManager().create(data);
    }

    public FHHologram(de.oliver.fancyholograms.api.Hologram hologram) {
        this.hologram = hologram;
    }

    private static Location getTopLocation(Location location, float scale, int lineCount) {
        Location newLocation = Objects.requireNonNull(location).clone();
        newLocation.setY(newLocation.getY() + 0.25 * (double)scale * (double)lineCount);
        return newLocation;
    }

    private static Location getBottomLocation(Location location, float scale, int lineCount) {
        Location newLocation = Objects.requireNonNull(location).clone();
        newLocation.setY(newLocation.getY() - 0.25 * (double)scale * (double)lineCount);
        return newLocation;
    }

    private Location getTopLocation() {
        return FHHologram.getTopLocation(this.hologram.getData().getLocation(), this.hologram.getData().getScale(), this.hologram.getData().getText().size());
    }

    private void setTopLocation(Location location) {
        this.hologram.getData().setLocation(FHHologram.getBottomLocation(location, this.hologram.getData().getScale(), this.hologram.getData().getText().size()));
    }

    private void updateTopLocation(int lineCount) {
        Location topLocation = FHHologram.getTopLocation(this.hologram.getData().getLocation(), this.hologram.getData().getScale(), this.hologram.getData().getText().size());
        Location bottomLocation = FHHologram.getBottomLocation(topLocation, this.hologram.getData().getScale(), lineCount);
        this.hologram.getData().setLocation(bottomLocation);
    }

    private void checkHologramInitialized() {
        Preconditions.checkArgument((boolean)this.isInitialized(), (Object)"Hologram is not initialized");
    }

    private void updateHologram() {
        this.hologram.updateHologram();
        FancyHologramsPlugin.get().getHologramsManager().refreshHologramForPlayersInWorld(this.hologram);
    }

    @NotNull
    public List<HologramLine> getLines() {
        this.checkHologramInitialized();
        return this.hologram.getData().getText().stream().map(TextHologramLine::new).collect(Collectors.toList());
    }

    public void setLines(@NotNull List<HologramLine> lines) {
        this.checkHologramInitialized();
        this.hologram.getData().setText((Collection)lines.stream().map(HologramLine::getRawContent).collect(Collectors.toList()));
        this.updateHologram();
    }

    private void editLine(Consumer<List<HologramLine>> consumer) {
        this.checkHologramInitialized();
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>(this.getLines());
        consumer.accept(lines);
        this.updateTopLocation(lines.size());
        this.setLines(lines);
    }

    public void addLine(@NotNull HologramLine line) {
        this.editLine(lines -> lines.add(line));
    }

    public void insertLine(int index, @NotNull HologramLine line) {
        this.editLine(lines -> lines.add(index, line));
    }

    public void removeLine(int index) {
        this.editLine(lines -> lines.remove(index));
    }

    public String getName() {
        return this.hologram.getData().getName();
    }

    public void init() {
        this.hologram.createHologram();
        this.hologram.showHologram(Bukkit.getOnlinePlayers());
        FancyHologramsPlugin.get().getHologramsManager().addHologram(this.hologram);
    }

    public void clear() {
        this.hologram.hideHologram(Bukkit.getOnlinePlayers());
        this.hologram.deleteHologram();
        FancyHologramsPlugin.get().getHologramsManager().removeHologram(this.hologram);
    }

    public boolean isInitialized() {
        return FancyHologramsPlugin.get().getHologramsManager().getHolograms().contains(this.hologram);
    }

    public Location getLocation() {
        this.checkHologramInitialized();
        return this.getTopLocation();
    }

    public void setLocation(Location location) {
        this.checkHologramInitialized();
        this.setTopLocation(location);
        this.updateHologram();
    }

    public boolean isVisible(Player viewer) {
        this.checkHologramInitialized();
        return this.hologram.isShown(viewer);
    }

    public void showAll() {
        this.checkHologramInitialized();
        this.hologram.showHologram(Bukkit.getOnlinePlayers());
    }

    public void hideAll() {
        this.checkHologramInitialized();
        this.hologram.hideHologram(Bukkit.getOnlinePlayers());
    }

    public void showTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.showHologram(viewer);
    }

    public void hideTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.hideHologram(viewer);
    }
}

