/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.fancyholograms.hologram;

import com.google.common.base.Preconditions;
import de.oliver.fancyholograms.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.Hologram;
import de.oliver.fancyholograms.api.HologramData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.display.DisplayBillboard;
import me.hsgamer.unihologram.display.DisplayHologram;
import me.hsgamer.unihologram.display.DisplayTextAlignment;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.hologram.extra.PlayerVisibility;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;

public class FHHologram
implements me.hsgamer.unihologram.common.api.Hologram<Location>,
Colored,
PlayerVisibility,
DisplayHologram<Location> {
    private static final double LINE_HEIGHT = 0.25;
    private final Hologram hologram;

    public FHHologram(String name, Location location) {
        HologramData data = new HologramData(name);
        data.setLocation(location);
        this.hologram = FancyHologramsPlugin.get().getHologramsManager().create(data);
    }

    public FHHologram(Hologram hologram) {
        this.hologram = hologram;
    }

    private static Location getTopLocation(Location location, float scale, int lineCount) {
        Location newLocation = Objects.requireNonNull(location).clone();
        newLocation.setY(newLocation.getY() + 0.25 * (double)scale * (double)lineCount);
        return newLocation;
    }

    private static Location getBottomLocation(Location location, float scale, int lineCount) {
        Location newLocation = Objects.requireNonNull(location).clone();
        newLocation.setY(newLocation.getY() - 0.25 * (double)scale * (double)lineCount);
        return newLocation;
    }

    private Location getTopLocation() {
        return FHHologram.getTopLocation(this.hologram.getData().getLocation(), this.hologram.getData().getScale(), this.hologram.getData().getText().size());
    }

    private void setTopLocation(Location location) {
        this.hologram.getData().setLocation(FHHologram.getBottomLocation(location, this.hologram.getData().getScale(), this.hologram.getData().getText().size()));
    }

    private void updateTopLocation(float scale, int lineCount) {
        Location topLocation = FHHologram.getTopLocation(this.hologram.getData().getLocation(), this.hologram.getData().getScale(), this.hologram.getData().getText().size());
        Location bottomLocation = FHHologram.getBottomLocation(topLocation, scale, lineCount);
        this.hologram.getData().setLocation(bottomLocation);
    }

    private void updateTopLocation(int lineCount) {
        this.updateTopLocation(this.hologram.getData().getScale(), lineCount);
    }

    private void checkHologramInitialized() {
        Preconditions.checkArgument((boolean)this.isInitialized(), (Object)"Hologram is not initialized");
    }

    private void updateHologram() {
        this.hologram.updateHologram();
        FancyHologramsPlugin.get().getHologramsManager().refreshHologramForPlayersInWorld(this.hologram);
    }

    private String toText(HologramLine line) {
        String content;
        String colored;
        if (line instanceof TextHologramLine && (colored = this.colorize(content = (String)((TextHologramLine)line).getContent())).contains(String.valueOf('\u00a7'))) {
            TextComponent coloredComponent = LegacyComponentSerializer.legacySection().deserialize(colored);
            return (String)MiniMessage.miniMessage().serializeOr((Component)coloredComponent, (Object)line.getRawContent());
        }
        return line.getRawContent();
    }

    private List<String> toText(List<HologramLine> lines) {
        return lines.stream().map(this::toText).collect(Collectors.toList());
    }

    @NotNull
    public List<HologramLine> getLines() {
        this.checkHologramInitialized();
        return this.hologram.getData().getText().stream().map(TextHologramLine::new).collect(Collectors.toList());
    }

    public void setLines(@NotNull List<HologramLine> lines) {
        this.checkHologramInitialized();
        this.hologram.getData().setText(this.toText(lines));
        this.updateHologram();
    }

    private void editLine(Consumer<List<HologramLine>> consumer) {
        this.checkHologramInitialized();
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>(this.getLines());
        consumer.accept(lines);
        this.updateTopLocation(lines.size());
        this.setLines(lines);
    }

    public void addLine(@NotNull HologramLine line) {
        this.editLine(lines -> lines.add(line));
    }

    public void insertLine(int index, @NotNull HologramLine line) {
        this.editLine(lines -> lines.add(index, line));
    }

    public void removeLine(int index) {
        this.editLine(lines -> lines.remove(index));
    }

    public String getName() {
        return this.hologram.getData().getName();
    }

    public void init() {
        this.hologram.createHologram();
        this.hologram.showHologram(Bukkit.getOnlinePlayers());
        FancyHologramsPlugin.get().getHologramsManager().addHologram(this.hologram);
    }

    public void clear() {
        this.hologram.hideHologram(Bukkit.getOnlinePlayers());
        this.hologram.deleteHologram();
        FancyHologramsPlugin.get().getHologramsManager().removeHologram(this.hologram);
    }

    public boolean isInitialized() {
        return FancyHologramsPlugin.get().getHologramsManager().getHolograms().contains(this.hologram);
    }

    public Location getLocation() {
        this.checkHologramInitialized();
        return this.getTopLocation();
    }

    public void setLocation(Location location) {
        this.checkHologramInitialized();
        this.setTopLocation(location);
        this.updateHologram();
    }

    public boolean isVisible(Player viewer) {
        this.checkHologramInitialized();
        return this.hologram.isShown(viewer);
    }

    public void showAll() {
        this.checkHologramInitialized();
        this.hologram.showHologram(Bukkit.getOnlinePlayers());
    }

    public void hideAll() {
        this.checkHologramInitialized();
        this.hologram.hideHologram(Bukkit.getOnlinePlayers());
    }

    public void showTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.showHologram(viewer);
    }

    public void hideTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.hideHologram(viewer);
    }

    public Color getBackgroundColor() {
        this.checkHologramInitialized();
        TextColor color = this.hologram.getData().getBackground();
        return color != null ? new Color(color.red(), color.green(), color.blue()) : null;
    }

    public void setBackgroundColor(Color color) {
        this.checkHologramInitialized();
        this.hologram.getData().setBackground(color != null ? TextColor.color((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()) : null);
        this.updateHologram();
    }

    public float getScale() {
        this.checkHologramInitialized();
        return this.hologram.getData().getScale();
    }

    public void setScale(float scale) {
        this.checkHologramInitialized();
        this.updateTopLocation(scale, this.hologram.getData().getText().size());
        this.hologram.getData().setScale(scale);
        this.updateHologram();
    }

    public float getShadowRadius() {
        this.checkHologramInitialized();
        return this.hologram.getData().getShadowRadius();
    }

    public void setShadowRadius(float radius) {
        this.checkHologramInitialized();
        this.hologram.getData().setShadowRadius(radius);
        this.updateHologram();
    }

    public float getShadowStrength() {
        this.checkHologramInitialized();
        return this.hologram.getData().getShadowStrength();
    }

    public void setShadowStrength(float strength) {
        this.checkHologramInitialized();
        this.hologram.getData().setShadowStrength(strength);
        this.updateHologram();
    }

    public boolean isShadowed() {
        this.checkHologramInitialized();
        return this.hologram.getData().isTextHasShadow();
    }

    public void setShadowed(boolean shadowed) {
        this.checkHologramInitialized();
        this.hologram.getData().setTextHasShadow(shadowed);
        this.updateHologram();
    }

    public DisplayBillboard getBillboard() {
        this.checkHologramInitialized();
        switch (this.hologram.getData().getBillboard()) {
            case FIXED: {
                return DisplayBillboard.FIXED;
            }
            case VERTICAL: {
                return DisplayBillboard.VERTICAL;
            }
            case HORIZONTAL: {
                return DisplayBillboard.HORIZONTAL;
            }
        }
        return DisplayBillboard.CENTER;
    }

    public void setBillboard(DisplayBillboard billboard) {
        this.checkHologramInitialized();
        switch (billboard) {
            case FIXED: {
                this.hologram.getData().setBillboard(Display.Billboard.FIXED);
                break;
            }
            case VERTICAL: {
                this.hologram.getData().setBillboard(Display.Billboard.VERTICAL);
                break;
            }
            case HORIZONTAL: {
                this.hologram.getData().setBillboard(Display.Billboard.HORIZONTAL);
                break;
            }
            default: {
                this.hologram.getData().setBillboard(Display.Billboard.CENTER);
            }
        }
        this.updateHologram();
    }

    public DisplayTextAlignment getAlignment() {
        this.checkHologramInitialized();
        switch (this.hologram.getData().getTextAlignment()) {
            case LEFT: {
                return DisplayTextAlignment.LEFT;
            }
            case RIGHT: {
                return DisplayTextAlignment.RIGHT;
            }
        }
        return DisplayTextAlignment.CENTER;
    }

    public void setAlignment(DisplayTextAlignment alignment) {
        this.checkHologramInitialized();
        switch (alignment) {
            case LEFT: {
                this.hologram.getData().setTextAlignment(TextDisplay.TextAlignment.LEFT);
                break;
            }
            case RIGHT: {
                this.hologram.getData().setTextAlignment(TextDisplay.TextAlignment.RIGHT);
                break;
            }
            default: {
                this.hologram.getData().setTextAlignment(TextDisplay.TextAlignment.CENTER);
            }
        }
        this.updateHologram();
    }

    public Location getOriginLocation() {
        this.checkHologramInitialized();
        return this.hologram.getData().getLocation();
    }

    public void setOriginLocation(Location originLocation) {
        this.checkHologramInitialized();
        this.hologram.getData().setLocation(originLocation);
        this.updateHologram();
    }
}

