/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.decentholograms.hologram;

import com.google.common.base.Preconditions;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.hologram.extra.PlayerVisibility;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import me.hsgamer.unihologram.spigot.common.line.SkullHologramLine;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DHHologram
implements me.hsgamer.unihologram.common.api.Hologram<Location>,
PlayerVisibility,
Colored {
    private static final boolean IS_FLAT;
    private final Supplier<Hologram> hologramSupplier;
    private final String name;
    private Hologram hologram;

    public DHHologram(String name, Location location) {
        this.name = name;
        this.hologramSupplier = () -> DHAPI.createHologram((String)name, (Location)location);
    }

    public DHHologram(Hologram hologram) {
        this(hologram.getName(), hologram.getLocation().clone());
        this.hologram = hologram;
    }

    private void checkHologramInitialized() {
        Preconditions.checkNotNull((Object)this.hologram, (Object)"Hologram is not initialized");
    }

    private String toDHContent(me.hsgamer.unihologram.common.api.HologramLine line) {
        if (line instanceof ItemHologramLine) {
            return "#ICON:" + HologramItem.fromItemStack((ItemStack)((ItemStack)((ItemHologramLine)line).getContent())).getContent();
        }
        if (line instanceof SkullHologramLine) {
            String lineContent = (String)((SkullHologramLine)line).getContent();
            boolean smallHead = Optional.ofNullable(line.getSettings().get("small-head")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
            return "#" + (smallHead ? "SMALLHEAD" : "HEAD") + ": " + (IS_FLAT ? "PLAYER_HEAD" : "SKULL_ITEM") + " (" + lineContent + ")";
        }
        if (line instanceof TextHologramLine) {
            return (String)((TextHologramLine)line).getContent();
        }
        return line.getRawContent();
    }

    private me.hsgamer.unihologram.common.api.HologramLine fromDHLine(HologramLine line) {
        switch (line.getType()) {
            case ICON: {
                return new ItemHologramLine(line.getItem().parse());
            }
            case SMALLHEAD: 
            case HEAD: {
                return new SkullHologramLine(line.getItem().getExtras());
            }
        }
        return new TextHologramLine(line.getContent());
    }

    @Override
    @NotNull
    public List<me.hsgamer.unihologram.common.api.HologramLine> getLines() {
        this.checkHologramInitialized();
        HologramPage page = this.hologram.getPage(0);
        if (page == null) {
            return Collections.emptyList();
        }
        return page.getLines().stream().map(this::fromDHLine).collect(Collectors.toList());
    }

    @Override
    public void setLines(@NotNull List<me.hsgamer.unihologram.common.api.HologramLine> lines) {
        this.checkHologramInitialized();
        List content = lines.stream().map(this::toDHContent).collect(Collectors.toList());
        DHAPI.setHologramLines((Hologram)this.hologram, content);
    }

    @Override
    public void addLine(@NotNull me.hsgamer.unihologram.common.api.HologramLine line) {
        this.checkHologramInitialized();
        DHAPI.addHologramLine((Hologram)this.hologram, (String)this.toDHContent(line));
    }

    @Override
    public void insertLine(int index, @NotNull me.hsgamer.unihologram.common.api.HologramLine line) {
        this.checkHologramInitialized();
        DHAPI.insertHologramLine((Hologram)this.hologram, (int)index, (String)this.toDHContent(line));
    }

    @Override
    public void setLine(int index, @NotNull me.hsgamer.unihologram.common.api.HologramLine line) {
        this.checkHologramInitialized();
        DHAPI.setHologramLine((Hologram)this.hologram, (int)index, (String)this.toDHContent(line));
    }

    @Override
    public void removeLine(int index) {
        this.checkHologramInitialized();
        DHAPI.removeHologramLine((Hologram)this.hologram, (int)index);
    }

    @Override
    public Optional<me.hsgamer.unihologram.common.api.HologramLine> getLine(int index) {
        this.checkHologramInitialized();
        HologramPage page = this.hologram.getPage(0);
        if (page == null) {
            return Optional.empty();
        }
        HologramLine line = page.getLine(index);
        if (line == null) {
            return Optional.empty();
        }
        return Optional.of(this.fromDHLine(line));
    }

    @Override
    public int size() {
        this.checkHologramInitialized();
        return this.hologram.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init() {
        this.hologram = this.hologramSupplier.get();
    }

    @Override
    public void clear() {
        try {
            if (this.hologram != null) {
                this.hologram.delete();
                this.hologram = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isInitialized() {
        return this.hologram != null;
    }

    @Override
    public Location getLocation() {
        this.checkHologramInitialized();
        return this.hologram.getLocation();
    }

    @Override
    public void setLocation(Location location) {
        this.checkHologramInitialized();
        DHAPI.moveHologram((Hologram)this.hologram, (Location)location);
    }

    @Override
    public boolean isVisible(Player viewer) {
        this.checkHologramInitialized();
        return this.hologram.isVisible(viewer);
    }

    @Override
    public void showAll() {
        this.checkHologramInitialized();
        this.hologram.showAll();
    }

    @Override
    public void hideAll() {
        this.checkHologramInitialized();
        this.hologram.hideAll();
    }

    @Override
    public void showTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.show(viewer, 0);
    }

    @Override
    public void hideTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.hide(viewer);
    }

    static {
        boolean isFlat = false;
        try {
            Class.forName("org.bukkit.block.data.BlockData");
            isFlat = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_FLAT = isFlat;
    }
}

