/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.common.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramProvider;
import org.jetbrains.annotations.NotNull;

public abstract class LocalHologramProvider<T>
implements HologramProvider<T> {
    private final Map<String, Hologram<T>> createdHolograms = new HashMap<String, Hologram<T>>();

    @NotNull
    protected abstract Hologram<T> newHologram(@NotNull String var1, @NotNull T var2);

    @Override
    @NotNull
    public final Hologram<T> createHologram(@NotNull String name, @NotNull T location) {
        if (this.createdHolograms.containsKey(name)) {
            throw new IllegalArgumentException("Hologram " + name + " already exists");
        }
        Hologram<T> hologram = this.newHologram(name, location);
        this.createdHolograms.put(name, hologram);
        return hologram;
    }

    @Override
    public Optional<Hologram<T>> getHologram(@NotNull String name) {
        return Optional.ofNullable(this.createdHolograms.get(name));
    }

    @Override
    public Collection<Hologram<T>> getAllHolograms() {
        return Collections.unmodifiableCollection(this.createdHolograms.values());
    }

    @Override
    public boolean isLocal() {
        return true;
    }
}

