/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.common.api;

import java.util.List;
import java.util.Optional;
import me.hsgamer.unihologram.common.api.HologramLine;
import org.jetbrains.annotations.NotNull;

public interface Hologram<T> {
    @NotNull
    public List<HologramLine> getLines();

    public void setLines(@NotNull List<HologramLine> var1);

    public void addLine(@NotNull HologramLine var1);

    public void insertLine(int var1, @NotNull HologramLine var2);

    public void removeLine(int var1);

    default public void setLine(int index, @NotNull HologramLine line) {
        this.insertLine(index, line);
        this.removeLine(index + 1);
    }

    default public Optional<HologramLine> getLine(int index) {
        List<HologramLine> lines = this.getLines();
        if (index < 0 || index >= lines.size()) {
            return Optional.empty();
        }
        return Optional.of(lines.get(index));
    }

    default public int size() {
        return this.getLines().size();
    }

    public String getName();

    public void init();

    public void clear();

    public boolean isInitialized();

    public T getLocation();

    public void setLocation(T var1);
}

