/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.common.api;

import java.util.List;
import java.util.Optional;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramLine;
import org.jetbrains.annotations.NotNull;

public interface PagedHologram<T>
extends Hologram<T> {
    default public int getFirstPage() {
        return 0;
    }

    public int getPages();

    @NotNull
    public List<HologramLine> getLines(int var1);

    public void setLines(int var1, @NotNull List<HologramLine> var2);

    public void addLine(int var1, @NotNull HologramLine var2);

    public void insertLine(int var1, int var2, @NotNull HologramLine var3);

    public void removeLine(int var1, int var2);

    default public void setLine(int page, int index, @NotNull HologramLine line) {
        this.insertLine(page, index, line);
        this.removeLine(page, index + 1);
    }

    default public Optional<HologramLine> getLine(int page, int index) {
        List<HologramLine> lines = this.getLines(page);
        if (index < 0 || index >= lines.size()) {
            return Optional.empty();
        }
        return Optional.of(lines.get(index));
    }

    default public int size(int page) {
        return this.getLines(page).size();
    }

    @Override
    @NotNull
    default public List<HologramLine> getLines() {
        return this.getLines(this.getFirstPage());
    }

    @Override
    default public void setLines(@NotNull List<HologramLine> lines) {
        this.setLines(this.getFirstPage(), lines);
    }

    @Override
    default public void addLine(@NotNull HologramLine line) {
        this.addLine(this.getFirstPage(), line);
    }

    @Override
    default public void insertLine(int index, @NotNull HologramLine line) {
        this.insertLine(this.getFirstPage(), index, line);
    }

    @Override
    default public void removeLine(int index) {
        this.removeLine(0, index);
    }

    @Override
    default public void setLine(int index, @NotNull HologramLine line) {
        this.setLine(this.getFirstPage(), index, line);
    }

    @Override
    default public Optional<HologramLine> getLine(int index) {
        return this.getLine(this.getFirstPage(), index);
    }

    @Override
    default public int size() {
        return this.size(this.getFirstPage());
    }
}

