/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.common.hologram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramLine;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleHologram<T>
implements Hologram<T> {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    protected List<HologramLine> lines;
    protected String name;
    protected T location;

    protected SimpleHologram(String name, T location) {
        this.name = name;
        this.location = location;
        this.lines = new ArrayList<HologramLine>();
    }

    private void checkInitialized() {
        if (!this.initialized.get()) {
            throw new IllegalStateException("Hologram is not initialized");
        }
    }

    protected abstract void updateHologram();

    protected abstract void initHologram();

    protected abstract void clearHologram();

    @Override
    @NotNull
    public List<HologramLine> getLines() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.lines);
    }

    @Override
    public void setLines(@NotNull List<HologramLine> lines) {
        this.checkInitialized();
        this.lines = new ArrayList<HologramLine>(lines);
        this.updateHologram();
    }

    @Override
    public void addLine(@NotNull HologramLine line) {
        this.checkInitialized();
        this.lines.add(line);
        this.updateHologram();
    }

    @Override
    public void setLine(int index, @NotNull HologramLine line) {
        this.checkInitialized();
        this.lines.set(index, line);
        this.updateHologram();
    }

    @Override
    public void insertLine(int index, @NotNull HologramLine line) {
        this.checkInitialized();
        this.lines.add(index, line);
        this.updateHologram();
    }

    @Override
    public void removeLine(int index) {
        this.checkInitialized();
        this.lines.remove(index);
        this.updateHologram();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.initHologram();
        }
    }

    @Override
    public void clear() {
        if (this.initialized.compareAndSet(true, false)) {
            this.clearHologram();
            this.lines.clear();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public T getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(T location) {
        this.checkInitialized();
        this.location = location;
        this.updateHologram();
    }
}

