/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.holographicdisplays.hologram;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.hologram.HologramLines;
import me.filoghost.holographicdisplays.api.hologram.VisibilitySettings;
import me.filoghost.holographicdisplays.api.hologram.line.ItemHologramLine;
import me.filoghost.holographicdisplays.api.hologram.line.TextHologramLine;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.line.EmptyHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.hologram.extra.PlayerVisibility;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HDHologram
implements me.hsgamer.unihologram.common.api.Hologram<Location>,
PlayerVisibility,
Colored {
    private final String name;
    private final Supplier<Hologram> hologramSupplier;
    private Hologram hologram;

    public HDHologram(Plugin plugin, String name, Location location) {
        this.name = name;
        this.hologramSupplier = () -> HolographicDisplaysAPI.get((Plugin)plugin).createHologram(location);
    }

    private void checkHologramInitialized() {
        Preconditions.checkNotNull((Object)this.hologram, (Object)"Hologram is not initialized");
    }

    private HologramLine fromHDLine(me.filoghost.holographicdisplays.api.hologram.line.HologramLine hdLine) {
        if (hdLine instanceof ItemHologramLine) {
            return new me.hsgamer.unihologram.spigot.common.line.ItemHologramLine(((ItemHologramLine)hdLine).getItemStack());
        }
        if (hdLine instanceof TextHologramLine) {
            return new me.hsgamer.unihologram.common.line.TextHologramLine(this.decolorize(((TextHologramLine)hdLine).getText()));
        }
        return new EmptyHologramLine();
    }

    @Override
    @NotNull
    public List<HologramLine> getLines() {
        this.checkHologramInitialized();
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>();
        HologramLines hdLines = this.hologram.getLines();
        int size = hdLines.size();
        for (int i = 0; i < size; ++i) {
            lines.add(this.fromHDLine(hdLines.get(i)));
        }
        return Collections.unmodifiableList(lines);
    }

    @Override
    public void setLines(@NotNull List<HologramLine> lines) {
        this.checkHologramInitialized();
        HologramLines hdLines = this.hologram.getLines();
        hdLines.clear();
        for (HologramLine line : lines) {
            if (line instanceof me.hsgamer.unihologram.spigot.common.line.ItemHologramLine) {
                hdLines.appendItem((ItemStack)((me.hsgamer.unihologram.spigot.common.line.ItemHologramLine)line).getContent());
                continue;
            }
            if (line instanceof me.hsgamer.unihologram.common.line.TextHologramLine) {
                hdLines.appendText(this.colorize((String)((me.hsgamer.unihologram.common.line.TextHologramLine)line).getContent()));
                continue;
            }
            hdLines.appendText(line.getRawContent());
        }
    }

    @Override
    public void addLine(@NotNull HologramLine line) {
        this.checkHologramInitialized();
        HologramLines hdLines = this.hologram.getLines();
        if (line instanceof me.hsgamer.unihologram.spigot.common.line.ItemHologramLine) {
            hdLines.appendItem((ItemStack)((me.hsgamer.unihologram.spigot.common.line.ItemHologramLine)line).getContent());
        } else if (line instanceof me.hsgamer.unihologram.common.line.TextHologramLine) {
            hdLines.appendText(this.colorize((String)((me.hsgamer.unihologram.common.line.TextHologramLine)line).getContent()));
        } else {
            hdLines.appendText(line.getRawContent());
        }
    }

    @Override
    public void insertLine(int index, @NotNull HologramLine line) {
        this.checkHologramInitialized();
        HologramLines hdLines = this.hologram.getLines();
        if (line instanceof me.hsgamer.unihologram.spigot.common.line.ItemHologramLine) {
            hdLines.insertItem(index, (ItemStack)((me.hsgamer.unihologram.spigot.common.line.ItemHologramLine)line).getContent());
        } else if (line instanceof me.hsgamer.unihologram.common.line.TextHologramLine) {
            hdLines.insertText(index, this.colorize((String)((me.hsgamer.unihologram.common.line.TextHologramLine)line).getContent()));
        } else {
            hdLines.insertText(index, line.getRawContent());
        }
    }

    @Override
    public void removeLine(int index) {
        this.checkHologramInitialized();
        this.hologram.getLines().remove(index);
    }

    @Override
    public Optional<HologramLine> getLine(int index) {
        this.checkHologramInitialized();
        HologramLines hdLines = this.hologram.getLines();
        if (index < 0 || index >= hdLines.size()) {
            return Optional.empty();
        }
        return Optional.of(this.fromHDLine(hdLines.get(index)));
    }

    @Override
    public int size() {
        this.checkHologramInitialized();
        return this.hologram.getLines().size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init() {
        this.hologram = this.hologramSupplier.get();
    }

    @Override
    public void clear() {
        try {
            if (this.hologram != null) {
                this.hologram.delete();
                this.hologram = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isInitialized() {
        return this.hologram != null;
    }

    @Override
    public Location getLocation() {
        this.checkHologramInitialized();
        return this.hologram.getPosition().toLocation();
    }

    @Override
    public void setLocation(Location location) {
        this.checkHologramInitialized();
        this.hologram.setPosition(location);
    }

    @Override
    public boolean isVisible(Player viewer) {
        this.checkHologramInitialized();
        return this.hologram.getVisibilitySettings().isVisibleTo(viewer);
    }

    @Override
    public void showAll() {
        this.checkHologramInitialized();
        this.hologram.getVisibilitySettings().setGlobalVisibility(VisibilitySettings.Visibility.VISIBLE);
    }

    @Override
    public void hideAll() {
        this.checkHologramInitialized();
        this.hologram.getVisibilitySettings().setGlobalVisibility(VisibilitySettings.Visibility.HIDDEN);
    }

    @Override
    public void showTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.getVisibilitySettings().setIndividualVisibility(viewer, VisibilitySettings.Visibility.VISIBLE);
    }

    @Override
    public void hideTo(Player viewer) {
        this.checkHologramInitialized();
        this.hologram.getVisibilitySettings().setIndividualVisibility(viewer, VisibilitySettings.Visibility.HIDDEN);
    }
}

