/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.common.hologram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramLine;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleHologram<T>
implements Hologram<T> {
    private final List<HologramLine> lines;
    private final String name;

    protected SimpleHologram(String name) {
        this.name = name;
        this.lines = new ArrayList<HologramLine>();
    }

    private void update() {
        this.setLines(this.lines);
    }

    @Override
    @NotNull
    public List<HologramLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    @Override
    public void addLine(@NotNull HologramLine line) {
        this.lines.add(line);
        this.update();
    }

    @Override
    public void setLine(int index, @NotNull HologramLine line) {
        this.lines.set(index, line);
        this.update();
    }

    @Override
    public void insertLine(int index, @NotNull HologramLine line) {
        this.lines.add(index, line);
        this.update();
    }

    @Override
    public void removeLine(int index) {
        this.lines.remove(index);
        this.update();
    }

    @Override
    public Optional<HologramLine> getLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            return Optional.empty();
        }
        return Optional.of(this.lines.get(index));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

