/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.holographicdisplays.hologram;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.line.EmptyHologramLine;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.CommonSpigotHologram;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HDLegacyHologram
implements CommonSpigotHologram {
    private final String name;
    private final Supplier<Hologram> hologramSupplier;
    private Hologram hologram;

    public HDLegacyHologram(Plugin plugin, String name, Location location) {
        this.name = name;
        this.hologramSupplier = () -> HologramsAPI.createHologram((Plugin)plugin, (Location)location);
    }

    private void checkHologramInitialized() {
        Preconditions.checkNotNull((Object)this.hologram, (Object)"Hologram is not initialized");
    }

    private HologramLine fromHDLine(com.gmail.filoghost.holographicdisplays.api.line.HologramLine hdLine) {
        if (hdLine instanceof ItemLine) {
            return new ItemHologramLine(((ItemLine)hdLine).getItemStack());
        }
        if (hdLine instanceof TextLine) {
            return new TextHologramLine(this.decolorize(((TextLine)hdLine).getText()));
        }
        return new EmptyHologramLine();
    }

    @Override
    @NotNull
    public List<HologramLine> getLines() {
        this.checkHologramInitialized();
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>();
        int size = this.hologram.size();
        for (int i = 0; i < size; ++i) {
            lines.add(this.fromHDLine(this.hologram.getLine(i)));
        }
        return Collections.unmodifiableList(lines);
    }

    @Override
    public void setLines(@NotNull List<HologramLine> lines) {
        this.checkHologramInitialized();
        this.hologram.clearLines();
        for (HologramLine line : lines) {
            if (line instanceof ItemHologramLine) {
                this.hologram.appendItemLine((ItemStack)((ItemHologramLine)line).getContent());
                continue;
            }
            if (line instanceof TextHologramLine) {
                this.hologram.appendTextLine(this.colorize((String)((TextHologramLine)line).getContent()));
                continue;
            }
            this.hologram.appendTextLine(line.getRawContent());
        }
    }

    @Override
    public void addLine(@NotNull HologramLine line) {
        this.checkHologramInitialized();
        if (line instanceof ItemHologramLine) {
            this.hologram.appendItemLine((ItemStack)((ItemHologramLine)line).getContent());
        } else if (line instanceof TextHologramLine) {
            this.hologram.appendTextLine(this.colorize((String)((TextHologramLine)line).getContent()));
        } else {
            this.hologram.appendTextLine(line.getRawContent());
        }
    }

    @Override
    public void insertLine(int index, @NotNull HologramLine line) {
        this.checkHologramInitialized();
        if (line instanceof ItemHologramLine) {
            this.hologram.insertItemLine(index, (ItemStack)((ItemHologramLine)line).getContent());
        } else if (line instanceof TextHologramLine) {
            this.hologram.insertTextLine(index, this.colorize((String)((TextHologramLine)line).getContent()));
        } else {
            this.hologram.insertTextLine(index, line.getRawContent());
        }
    }

    @Override
    public void removeLine(int index) {
        this.checkHologramInitialized();
        this.hologram.removeLine(index);
    }

    @Override
    public Optional<HologramLine> getLine(int index) {
        this.checkHologramInitialized();
        if (index < 0 || index >= this.hologram.size()) {
            return Optional.empty();
        }
        return Optional.of(this.fromHDLine(this.hologram.getLine(index)));
    }

    @Override
    public int size() {
        this.checkHologramInitialized();
        return this.hologram.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init() {
        this.hologram = this.hologramSupplier.get();
    }

    @Override
    public void clear() {
        try {
            if (this.hologram != null) {
                this.hologram.delete();
                this.hologram = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isInitialized() {
        return this.hologram != null;
    }

    @Override
    public Location getLocation() {
        this.checkHologramInitialized();
        return this.hologram.getLocation();
    }

    @Override
    public void setLocation(Location location) {
        this.checkHologramInitialized();
        this.hologram.teleport(location);
    }
}

