/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.test.core.bukkit.command;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CommandManager {
    private static final Field knownCommandsField;
    private static final CommandMap bukkitCommandMap;
    private static Method syncCommandsMethod;
    protected final JavaPlugin plugin;
    private final Map<String, Command> registered = new HashMap<String, Command>();

    public CommandManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static void syncCommand() {
        if (syncCommandsMethod == null) {
            return;
        }
        try {
            syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Bukkit.getLogger().log(Level.WARNING, "Error when syncing commands", e);
        }
    }

    public static void unregisterFromKnownCommands(@NotNull Command command) throws IllegalAccessException {
        Map knownCommands = (Map)knownCommandsField.get(bukkitCommandMap);
        knownCommands.values().removeIf(command::equals);
        command.unregister(bukkitCommandMap);
    }

    public static void registerCommandToCommandMap(@NotNull String label, @NotNull Command command) {
        bukkitCommandMap.register(label, command);
    }

    public final void register(@NotNull Command command) {
        String name = command.getLabel();
        if (this.registered.containsKey(name)) {
            this.plugin.getLogger().log(Level.WARNING, "Duplicated \"{0}\" command ! Ignored", name);
            return;
        }
        CommandManager.registerCommandToCommandMap(this.plugin.getName(), command);
        this.registered.put(name, command);
    }

    public final void unregister(@NotNull Command command) {
        try {
            CommandManager.unregisterFromKnownCommands(command);
            this.registered.remove(command.getLabel());
        }
        catch (ReflectiveOperationException e) {
            this.plugin.getLogger().log(Level.WARNING, "Something wrong when unregister the command", e);
        }
    }

    public final void unregister(@NotNull String command) {
        if (this.registered.containsKey(command)) {
            this.unregister(this.registered.remove(command));
        }
    }

    public final void unregisterAll() {
        this.registered.values().forEach(command -> {
            try {
                CommandManager.unregisterFromKnownCommands(command);
            }
            catch (ReflectiveOperationException e) {
                this.plugin.getLogger().log(Level.WARNING, "Something wrong when unregister the command", e);
            }
        });
        this.registered.clear();
    }

    @NotNull
    public final Map<String, Command> getRegistered() {
        return Collections.unmodifiableMap(this.registered);
    }

    static {
        try {
            Method commandMapMethod = Bukkit.getServer().getClass().getMethod("getCommandMap", new Class[0]);
            bukkitCommandMap = (CommandMap)commandMapMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            Class<?> craftServer = Bukkit.getServer().getClass();
            syncCommandsMethod = craftServer.getDeclaredMethod("syncCommands", new Class[0]);
        }
        catch (Exception exception) {
        }
        finally {
            if (syncCommandsMethod != null) {
                syncCommandsMethod.setAccessible(true);
            }
        }
    }
}

