/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.test.core.bukkit.command.sub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.hsgamer.unihologram.spigot.test.core.bukkit.command.sub.SubCommand;
import me.hsgamer.unihologram.spigot.test.core.collections.map.CaseInsensitiveStringHashMap;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public abstract class SubCommandManager {
    protected static final String HELP = "help";
    protected final Map<String, SubCommand> subcommands = new CaseInsensitiveStringHashMap<SubCommand>();

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        if (args.length < 1 || args[0].equalsIgnoreCase(HELP)) {
            this.sendHelpMessage(sender, label, args);
            return true;
        }
        if (!this.subcommands.containsKey(args[0])) {
            this.sendArgNotFoundMessage(sender, label, args);
            return false;
        }
        return this.subcommands.get(args[0]).onCommand(sender, label, Arrays.copyOfRange(args, 1, args.length));
    }

    public abstract void sendHelpMessage(@NotNull CommandSender var1, @NotNull String var2, String ... var3);

    public abstract void sendArgNotFoundMessage(@NotNull CommandSender var1, @NotNull String var2, String ... var3);

    public final void registerSubcommand(@NotNull SubCommand subCommand) {
        if (subCommand.name.equalsIgnoreCase(HELP)) {
            throw new IllegalArgumentException("'help' is a predefined argument");
        }
        this.subcommands.put(subCommand.getName(), subCommand);
    }

    public final void unregisterSubcommand(@NotNull String name) {
        this.subcommands.remove(name);
    }

    public final void unregisterSubcommand(@NotNull SubCommand subCommand) {
        this.subcommands.remove(subCommand.getName());
    }

    @NotNull
    public final Map<String, SubCommand> getSubcommands() {
        return Collections.unmodifiableMap(this.subcommands);
    }

    public final List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length < 1 || args[0].isEmpty()) {
            list.add(HELP);
            list.addAll(this.subcommands.keySet());
        } else if (this.subcommands.containsKey(args[0])) {
            SubCommand subCommand = this.subcommands.get(args[0]);
            if (subCommand.isExecutable(sender, false)) {
                list.addAll(subCommand.onTabComplete(sender, label, Arrays.copyOfRange(args, 1, args.length)));
            }
        } else {
            for (String subLabel : this.subcommands.keySet()) {
                if (!subLabel.startsWith(args[0])) continue;
                list.add(subLabel);
            }
            if (HELP.startsWith(args[0])) {
                list.add(HELP);
            }
        }
        return list;
    }
}

