/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.test.core.collections.map;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseInsensitiveStringMap<V>
implements Map<String, V> {
    private final Map<String, V> delegate;

    public CaseInsensitiveStringMap(Map<String, V> delegate) {
        this.delegate = delegate;
        this.normalize();
    }

    private String getLowerCase(Object obj) {
        return String.valueOf(obj).toLowerCase(Locale.ROOT);
    }

    private void normalize() {
        LinkedHashMap<String, V> linkedMap = new LinkedHashMap<String, V>(this.delegate);
        this.clear();
        this.putAll((Map<? extends String, ? extends V>)linkedMap);
        linkedMap.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.delegate.containsKey(this.getLowerCase(o));
    }

    @Override
    public boolean containsValue(Object o) {
        return this.delegate.containsValue(o);
    }

    @Override
    public V get(Object o) {
        return this.delegate.get(this.getLowerCase(o));
    }

    @Override
    @Nullable
    public V put(String s, V v) {
        return this.delegate.put(this.getLowerCase(s), v);
    }

    @Override
    public V remove(Object o) {
        return this.delegate.remove(this.getLowerCase(o));
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, V>> entrySet() {
        return this.delegate.entrySet();
    }
}

