/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.test;

import java.util.Collection;
import java.util.HashMap;
import me.hsgamer.unihologram.common.api.Hologram;
import me.hsgamer.unihologram.common.api.HologramProvider;
import me.hsgamer.unihologram.spigot.SpigotHologramProvider;
import me.hsgamer.unihologram.spigot.plugin.UniHologramPlugin;
import org.bukkit.Location;
import org.bukkit.plugin.java.JavaPlugin;

public class HologramManager {
    private final SpigotHologramProvider provider = ((UniHologramPlugin)JavaPlugin.getPlugin(UniHologramPlugin.class)).getProvider();
    private final HologramHandler handler;

    public HologramManager() {
        HologramHandler hologramHandler;
        if (this.provider.isLocal()) {
            hologramHandler = new HologramHandler(){

                @Override
                public Hologram<Location> createHologram(String name, Location location) {
                    return HologramManager.this.provider.createHologram(name, location);
                }

                @Override
                public Collection<Hologram<Location>> getCreatedHolograms() {
                    return HologramManager.this.provider.getAllHolograms();
                }
            };
        } else {
            final HashMap map = new HashMap();
            hologramHandler = new HologramHandler(){

                @Override
                public Hologram<Location> createHologram(String name, Location location) {
                    Hologram hologram = HologramManager.this.provider.createHologram(name, location);
                    map.put(name, hologram);
                    return hologram;
                }

                @Override
                public Collection<Hologram<Location>> getCreatedHolograms() {
                    return map.values();
                }
            };
        }
        this.handler = hologramHandler;
    }

    public boolean createHologram(String name, Location location) {
        Hologram<Location> existingHologram = this.getHologram(name);
        if (existingHologram != null) {
            if (existingHologram.isInitialized()) {
                return false;
            }
            existingHologram.init();
            existingHologram.setLocation((Object)location);
        } else {
            this.handler.createHologram(name, location).init();
        }
        return true;
    }

    public HologramProvider<Location> getProvider() {
        return this.provider.getProvider();
    }

    public void clearAll() {
        this.handler.getCreatedHolograms().forEach(Hologram::clear);
    }

    public Hologram<Location> getHologram(String name) {
        return this.provider.getHologram(name).orElse(null);
    }

    private static interface HologramHandler {
        public Hologram<Location> createHologram(String var1, Location var2);

        public Collection<Hologram<Location>> getCreatedHolograms();
    }
}

