/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.folia;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.Runner;
import me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.Scheduler;
import me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.Task;
import me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.folia.FoliaAsyncRunner;
import me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.folia.FoliaSyncRunner;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements Scheduler {
    private final Cache<ScheduledTask, Boolean> tasks = CacheBuilder.newBuilder().weakKeys().build();
    private final FoliaSyncRunner syncRunner;
    private final FoliaAsyncRunner asyncRunner;
    private final Plugin plugin;

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.syncRunner = new FoliaSyncRunner(this);
        this.asyncRunner = new FoliaAsyncRunner(this);
    }

    static long normalizeTick(long tick) {
        return Math.max(1L, tick);
    }

    static long toMilliSecond(long tick) {
        return FoliaScheduler.normalizeTick(tick) * 50L;
    }

    static Consumer<ScheduledTask> wrapRunnable(BooleanSupplier runnable) {
        return scheduledTask -> {
            if (!runnable.getAsBoolean()) {
                scheduledTask.cancel();
            }
        };
    }

    static Consumer<ScheduledTask> wrapRunnable(Runnable runnable) {
        return scheduledTask -> runnable.run();
    }

    static Task wrapTask(final ScheduledTask scheduledTask, final boolean async) {
        return new Task(){

            @Override
            public boolean isCancelled() {
                return scheduledTask.isCancelled();
            }

            @Override
            public void cancel() {
                scheduledTask.cancel();
            }

            @Override
            public boolean isAsync() {
                return async;
            }

            @Override
            public boolean isRepeating() {
                return scheduledTask.isRepeatingTask();
            }

            @Override
            public Plugin getPlugin() {
                return scheduledTask.getOwningPlugin();
            }
        };
    }

    static boolean isEntityValid(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            return ((Player)entity).isOnline();
        }
        return entity.isValid();
    }

    Plugin getPlugin() {
        return this.plugin;
    }

    void addTask(ScheduledTask scheduledTask) {
        this.tasks.put((Object)scheduledTask, (Object)true);
    }

    @Override
    public void cancelAllTasks() {
        this.tasks.asMap().keySet().forEach(ScheduledTask::cancel);
        this.tasks.invalidateAll();
        Bukkit.getAsyncScheduler().cancelTasks(this.plugin);
        Bukkit.getGlobalRegionScheduler().cancelTasks(this.plugin);
    }

    @Override
    public Runner async() {
        return this.asyncRunner;
    }

    @Override
    public Runner sync() {
        return this.syncRunner;
    }
}

