/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.test.core.bukkit.simpleplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.hsgamer.unihologram.spigot.test.core.bukkit.folia.FoliaChecker;
import me.hsgamer.unihologram.spigot.test.core.bukkit.scheduler.Scheduler;
import me.hsgamer.unihologram.spigot.test.core.bukkit.simpleplugin.listener.BukkitPostEnableListener;
import me.hsgamer.unihologram.spigot.test.core.bukkit.simpleplugin.listener.FoliaPostEnableListener;
import me.hsgamer.unihologram.spigot.test.core.bukkit.simpleplugin.listener.PostEnableListener;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class SimplePlugin
extends JavaPlugin {
    private final PostEnableListener postEnableListener;
    private final List<Runnable> disableFunctions = new ArrayList<Runnable>();

    public SimplePlugin() {
        this.postEnableListener = FoliaChecker.isFolia() ? new FoliaPostEnableListener((Plugin)this) : new BukkitPostEnableListener((Plugin)this);
        this.preLoad();
    }

    public void onLoad() {
        this.load();
    }

    public void onEnable() {
        this.enable();
        this.postEnableListener.addPostEnableRunnable(this::postEnable);
        this.postEnableListener.setup();
    }

    public void onDisable() {
        this.disable();
        this.disableFunctions.forEach(Runnable::run);
        this.disableFunctions.clear();
        Scheduler.plugin((Plugin)this).cancelAllTasks();
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        this.postDisable();
    }

    public void preLoad() {
    }

    public void load() {
    }

    public void enable() {
    }

    public void postEnable() {
    }

    public void disable() {
    }

    public void postDisable() {
    }

    public void registerListener(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public <T> void registerProvider(Class<T> service, T provider, ServicePriority priority) {
        this.getServer().getServicesManager().register(service, provider, (Plugin)this, priority);
    }

    public <T> void registerProvider(Class<T> service, T provider) {
        this.registerProvider(service, provider, ServicePriority.Normal);
    }

    public <T> T loadProvider(Class<T> service) {
        return (T)this.getServer().getServicesManager().load(service);
    }

    public <T> RegisteredServiceProvider<T> getProvider(Class<T> service) {
        return this.getServer().getServicesManager().getRegistration(service);
    }

    public <T> Collection<RegisteredServiceProvider<T>> getAllProviders(Class<T> service) {
        return this.getServer().getServicesManager().getRegistrations(service);
    }

    public void addDisableFunction(Runnable disableFunction) {
        this.disableFunctions.add(disableFunction);
    }

    public void addPostEnableRunnable(Runnable runnable) {
        this.postEnableListener.addPostEnableRunnable(runnable);
    }
}

