/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.vanilla.hologram;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.hologram.SimpleHologram;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class VanillaHologram
extends SimpleHologram<Location>
implements Colored {
    private static final int VERSION;
    private final List<Entity> entities = new ArrayList<Entity>();

    public VanillaHologram(String name, Location location) {
        super(name, (Object)location);
    }

    protected void updateHologram() {
        this.clearHologram();
        World world = ((Location)this.location).getWorld();
        if (world == null) {
            return;
        }
        Location currentLocation = ((Location)this.location).clone();
        for (HologramLine line : this.lines) {
            ArmorStand entity;
            currentLocation = currentLocation.clone().add(0.0, -0.27, 0.0);
            if (line instanceof ItemHologramLine && VERSION >= 10) {
                currentLocation = currentLocation.clone().add(0.0, -0.4, 0.0);
                Location itemLocation = currentLocation.clone().add(0.0, 2.2, 0.0);
                Item item = world.dropItem(itemLocation, (ItemStack)((ItemHologramLine)line).getContent());
                entity = item;
                entity.setGravity(false);
                entity.setVelocity(new Vector(0, 0, 0));
                entity.teleport(itemLocation);
                entity.setInvulnerable(true);
                item.setPickupDelay(Integer.MAX_VALUE);
                item.setCustomNameVisible(false);
            } else {
                ArmorStand armorStand;
                entity = armorStand = (ArmorStand)world.spawn(currentLocation, ArmorStand.class);
                armorStand.setGravity(false);
                armorStand.setVisible(false);
                armorStand.setCustomNameVisible(true);
                armorStand.setInvulnerable(true);
                armorStand.setCustomName(line instanceof TextHologramLine ? this.colorize((String)((TextHologramLine)line).getContent()) : line.getRawContent());
            }
            this.entities.add((Entity)entity);
        }
    }

    protected void initHologram() {
    }

    protected void clearHologram() {
        this.entities.forEach(entity -> {
            try {
                entity.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.entities.clear();
    }

    static {
        Matcher matcher = Pattern.compile("MC: \\d\\.(\\d+)").matcher(Bukkit.getVersion());
        VERSION = matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
    }
}

