/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.vanilla.hologram;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.hologram.SimpleHologram;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class VanillaHologram
extends SimpleHologram<Location>
implements Colored {
    private static final int VERSION;
    private static final boolean IS_FOLIA;
    private final List<Entity> entities = new ArrayList<Entity>();
    private final AtomicReference<List<HologramLine>> linesRef = new AtomicReference();
    private final Plugin plugin;
    private Runnable cancelTaskRunnable;

    public VanillaHologram(Plugin plugin, String name, Location location) {
        super(name, (Object)location);
        this.plugin = plugin;
    }

    private void initTask() {
        this.cancelTaskRunnable = IS_FOLIA ? () -> ((ScheduledTask)Bukkit.getRegionScheduler().runAtFixedRate(this.plugin, (Location)this.location, s -> this.updateHologramEntity(), 5L, 5L)).cancel() : () -> ((BukkitTask)Bukkit.getScheduler().runTaskTimer(this.plugin, this::updateHologramEntity, 5L, 5L)).cancel();
    }

    protected void initHologram() {
        this.initTask();
    }

    public void setLocation(Location location) {
        if (this.cancelTaskRunnable != null) {
            this.cancelTaskRunnable.run();
            this.cancelTaskRunnable = null;
        }
        super.setLocation((Object)location);
        this.initTask();
    }

    private void updateHologramEntity() {
        List toUpdate = this.linesRef.getAndSet(null);
        if (toUpdate == null) {
            return;
        }
        this.clearHologramEntity();
        World world = ((Location)this.location).getWorld();
        if (world == null) {
            return;
        }
        Location currentLocation = ((Location)this.location).clone().add(0.0, -2.0, 0.0);
        for (HologramLine line : toUpdate) {
            ArmorStand entity;
            currentLocation = currentLocation.clone().add(0.0, -0.27, 0.0);
            if (line instanceof ItemHologramLine && VERSION >= 10) {
                currentLocation = currentLocation.clone().add(0.0, -0.4, 0.0);
                Location itemLocation = currentLocation.clone().add(0.0, 2.2, 0.0);
                Item item = world.dropItem(itemLocation, (ItemStack)((ItemHologramLine)line).getContent());
                entity = item;
                entity.setGravity(false);
                entity.setVelocity(new Vector(0, 0, 0));
                entity.teleport(itemLocation);
                entity.setInvulnerable(true);
                item.setPickupDelay(Integer.MAX_VALUE);
                item.setCustomNameVisible(false);
            } else {
                ArmorStand armorStand;
                entity = armorStand = (ArmorStand)world.spawn(currentLocation, ArmorStand.class);
                armorStand.setGravity(false);
                armorStand.setVisible(false);
                armorStand.setCustomNameVisible(true);
                armorStand.setInvulnerable(true);
                String content = line instanceof TextHologramLine ? this.colorize((String)((TextHologramLine)line).getContent()) : line.getRawContent();
                armorStand.setCustomName(content.isEmpty() ? ChatColor.RESET.toString() : content);
            }
            this.entities.add((Entity)entity);
        }
    }

    private void clearHologramEntity() {
        this.entities.forEach(entity -> {
            try {
                entity.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.entities.clear();
    }

    protected void updateHologram() {
        this.linesRef.set(Collections.unmodifiableList(this.lines));
    }

    protected void clearHologram() {
        if (this.cancelTaskRunnable != null) {
            this.cancelTaskRunnable.run();
            this.cancelTaskRunnable = null;
        }
        Runnable runnable = this::clearHologramEntity;
        if (this.plugin.isEnabled()) {
            if (IS_FOLIA) {
                Bukkit.getRegionScheduler().execute(this.plugin, (Location)this.location, runnable);
            } else {
                Bukkit.getScheduler().runTask(this.plugin, runnable);
            }
        } else {
            runnable.run();
        }
        this.linesRef.set(null);
    }

    static {
        boolean isFolia;
        Matcher matcher = Pattern.compile("MC: \\d\\.(\\d+)").matcher(Bukkit.getVersion());
        VERSION = matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia = true;
        }
        catch (ClassNotFoundException ignored) {
            isFolia = false;
        }
        IS_FOLIA = isFolia;
    }
}

