/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.unihologram.spigot.vanilla.hologram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.hsgamer.unihologram.common.api.HologramLine;
import me.hsgamer.unihologram.common.hologram.SimpleHologram;
import me.hsgamer.unihologram.common.line.TextHologramLine;
import me.hsgamer.unihologram.spigot.common.hologram.extra.Colored;
import me.hsgamer.unihologram.spigot.common.line.ItemHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class VanillaHologram
extends SimpleHologram<Location>
implements Colored {
    private static final int VERSION;
    private final Queue<Entity> entities = new LinkedBlockingQueue<Entity>();
    private final AtomicReference<List<Entity>> newEntitiesRef = new AtomicReference();
    private final AtomicReference<List<HologramLine>> linesRef = new AtomicReference();
    private final Plugin plugin;
    private BukkitTask updateTask;

    public VanillaHologram(Plugin plugin, String name, Location location) {
        super(name, (Object)location);
        this.plugin = plugin;
    }

    private static void removeIfNotNull(Entity entity) {
        if (entity != null) {
            try {
                entity.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void teleport(Entity entity, Location location) {
        Location currentLocation = entity.getLocation();
        if (currentLocation.getX() == location.getX() && currentLocation.getY() == location.getY() && currentLocation.getZ() == location.getZ()) {
            return;
        }
        entity.teleport(location);
    }

    protected void initHologram() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        this.updateTask = Bukkit.getScheduler().runTaskTimer(this.plugin, this::updateHologramEntity, 5L, 5L);
    }

    private void clearEntityQueue() {
        Entity entity;
        while ((entity = this.entities.poll()) != null) {
            VanillaHologram.removeIfNotNull(entity);
        }
    }

    private void updateHologramEntity() {
        List toUpdate = this.linesRef.getAndSet(null);
        if (toUpdate == null) {
            return;
        }
        World world = ((Location)this.location).getWorld();
        if (world == null) {
            return;
        }
        ArrayList<Entity> newEntities = new ArrayList<Entity>();
        this.newEntitiesRef.set(newEntities);
        Location currentLocation = ((Location)this.location).clone().add(0.0, -2.0, 0.0);
        for (HologramLine line : toUpdate) {
            Entity entity = this.entities.poll();
            currentLocation = currentLocation.clone().add(0.0, -0.27, 0.0);
            if (line instanceof ItemHologramLine && VERSION >= 10) {
                Item item;
                currentLocation = currentLocation.clone().add(0.0, -0.4, 0.0);
                Location itemLocation = currentLocation.clone().add(0.0, 2.2, 0.0);
                if (entity instanceof Item) {
                    item = (Item)entity;
                    ItemStack current = item.getItemStack();
                    ItemStack expected = (ItemStack)((ItemHologramLine)line).getContent();
                    if (!expected.isSimilar(current)) {
                        item.setItemStack(expected);
                    }
                    VanillaHologram.teleport((Entity)item, itemLocation);
                } else {
                    VanillaHologram.removeIfNotNull(entity);
                    item = world.dropItem(itemLocation, (ItemStack)((ItemHologramLine)line).getContent());
                    item.setGravity(false);
                    item.setVelocity(new Vector(0, 0, 0));
                    item.setInvulnerable(true);
                    item.setPickupDelay(Integer.MAX_VALUE);
                    item.setCustomNameVisible(false);
                }
                entity = item;
            } else {
                ArmorStand armorStand;
                if (entity instanceof ArmorStand) {
                    armorStand = (ArmorStand)entity;
                    VanillaHologram.teleport((Entity)armorStand, currentLocation);
                } else {
                    VanillaHologram.removeIfNotNull(entity);
                    armorStand = (ArmorStand)world.spawn(currentLocation, ArmorStand.class);
                    armorStand.setGravity(false);
                    armorStand.setVisible(false);
                    armorStand.setCustomNameVisible(true);
                    armorStand.setInvulnerable(true);
                }
                entity = armorStand;
                String content = line instanceof TextHologramLine ? this.colorize((String)((TextHologramLine)line).getContent()) : line.getRawContent();
                armorStand.setCustomName(content.isEmpty() ? ChatColor.RESET.toString() : content);
            }
            newEntities.add(entity);
        }
        this.clearEntityQueue();
        this.entities.addAll(newEntities);
        this.newEntitiesRef.set(null);
    }

    protected void updateHologram() {
        this.linesRef.set(Collections.unmodifiableList(this.lines));
    }

    protected void clearHologram() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        Runnable runnable = () -> {
            this.clearEntityQueue();
            List newEntities = this.newEntitiesRef.getAndSet(null);
            if (newEntities != null) {
                for (Entity entity : newEntities) {
                    VanillaHologram.removeIfNotNull(entity);
                }
            }
        };
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask(this.plugin, runnable);
        }
        this.linesRef.set(null);
    }

    static {
        Matcher matcher = Pattern.compile("MC: \\d\\.(\\d+)").matcher(Bukkit.getVersion());
        VERSION = matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
    }
}

