/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import jdk.incubator.foreign.MemoryAccess;
import jdk.incubator.foreign.MemorySegment;
import me.hugmanrique.cartage.Cartridge;

public abstract class AbstractCartridge
implements Cartridge {
    private final MemorySegment segment;
    private ByteOrder order;
    private long offset;

    protected AbstractCartridge(MemorySegment segment, ByteOrder order) {
        this.segment = Objects.requireNonNull(segment);
        this.order = Objects.requireNonNull(order);
        this.setOffset(0L);
    }

    protected AbstractCartridge(MemorySegment segment) {
        this(segment, ByteOrder.nativeOrder());
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public void order(ByteOrder order) {
        this.order = Objects.requireNonNull(order);
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = Objects.checkIndex(offset, this.size() + 1L);
    }

    @Override
    public long size() {
        return this.segment.byteSize();
    }

    @Override
    public long remaining() {
        return this.size() - this.offset;
    }

    @Override
    public boolean hasRemaining() {
        return this.offset < this.size();
    }

    @Override
    public void skip(long count) {
        this.setOffset(this.offset + count);
    }

    @Override
    public void close() {
        if (!this.segment.isAlive()) {
            throw new IllegalStateException("This cartridge is already closed");
        }
        this.segment.close();
    }

    @Override
    public byte readByte() {
        byte value = this.getByte(this.offset);
        ++this.offset;
        return value;
    }

    @Override
    public byte getByte(long offset) {
        return MemoryAccess.getByteAtOffset((MemorySegment)this.segment, (long)offset);
    }

    @Override
    public int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public int getUnsignedByte(long offset) {
        return Byte.toUnsignedInt(this.getByte(offset));
    }

    @Override
    public void writeByte(byte value) {
        this.setByte(this.offset, value);
        ++this.offset;
    }

    @Override
    public void setByte(long offset, byte value) {
        MemoryAccess.setByteAtOffset((MemorySegment)this.segment, (long)offset, (byte)value);
    }

    @Override
    public void writeUnsignedByte(int value) {
        this.writeByte((byte)(value & 0xFF));
    }

    @Override
    public void setUnsignedByte(long offset, int value) {
        this.setByte(offset, (byte)(value & 0xFF));
    }

    @Override
    public short readShort() {
        short value = this.getShort(this.offset);
        this.offset += 2L;
        return value;
    }

    @Override
    public short getShort(long offset) {
        return MemoryAccess.getShortAtOffset((MemorySegment)this.segment, (long)offset, (ByteOrder)this.order);
    }

    @Override
    public int readUnsignedShort() {
        return Short.toUnsignedInt(this.readShort());
    }

    @Override
    public int getUnsignedShort(long offset) {
        return Short.toUnsignedInt(this.getShort(offset));
    }

    @Override
    public void writeShort(short value) {
        this.setShort(this.offset, value);
        this.offset += 2L;
    }

    @Override
    public void setShort(long offset, short value) {
        MemoryAccess.setShortAtOffset((MemorySegment)this.segment, (long)offset, (ByteOrder)this.order, (short)value);
    }

    @Override
    public void writeUnsignedShort(int value) {
        this.writeShort((short)(value & 0xFFFF));
    }

    @Override
    public void setUnsignedShort(long offset, int value) {
        this.setShort(offset, (short)(value & 0xFFFF));
    }

    @Override
    public int readInt() {
        int value = this.getInt(this.offset);
        this.offset += 4L;
        return value;
    }

    @Override
    public int getInt(long offset) {
        return MemoryAccess.getIntAtOffset((MemorySegment)this.segment, (long)offset, (ByteOrder)this.order);
    }

    @Override
    public long readUnsignedInt() {
        return Integer.toUnsignedLong(this.readInt());
    }

    @Override
    public long getUnsignedInt(long offset) {
        return Integer.toUnsignedLong(this.getInt(offset));
    }

    @Override
    public void writeInt(int value) {
        this.setInt(this.offset, value);
        this.offset += 4L;
    }

    @Override
    public void setInt(long offset, int value) {
        MemoryAccess.setIntAtOffset((MemorySegment)this.segment, (long)offset, (ByteOrder)this.order, (int)value);
    }

    @Override
    public void writeUnsignedInt(long value) {
        this.writeInt((int)(value & 0xFFFFFFFFL));
    }

    @Override
    public void setUnsignedInt(long offset, long value) {
        this.setInt(offset, (int)(value & 0xFFFFFFFFL));
    }

    @Override
    public long readLong() {
        long value = this.getLong(this.offset);
        this.offset += 8L;
        return value;
    }

    @Override
    public long getLong(long offset) {
        return MemoryAccess.getLongAtOffset((MemorySegment)this.segment, (long)offset, (ByteOrder)this.order);
    }

    @Override
    public void writeLong(long value) {
        this.setLong(this.offset, value);
        this.offset += 8L;
    }

    @Override
    public void setLong(long offset, long value) {
        MemoryAccess.setLongAtOffset((MemorySegment)this.segment, (long)offset, (ByteOrder)this.order, (long)value);
    }

    @Override
    public void readBytes(byte[] dest) {
        this.getBytes(this.offset, dest, 0, dest.length);
        this.offset += (long)dest.length;
    }

    @Override
    public void readBytes(byte[] destArray, int destOffset, int length) {
        this.getBytes(this.offset, destArray, destOffset, length);
        this.offset += (long)length;
    }

    @Override
    public void getBytes(long offset, byte[] dest) {
        this.getBytes(offset, dest, 0, dest.length);
    }

    @Override
    public void getBytes(long offset, byte[] destArray, int destOffset, int length) {
        try (MemorySegment dest = MemorySegment.ofArray((byte[])destArray);){
            dest.asSlice((long)destOffset, (long)length).copyFrom(this.segment.asSlice(offset, (long)length));
        }
    }

    @Override
    public void writeBytes(byte[] source) {
        this.setBytes(this.offset, source, 0, source.length);
        this.offset += (long)source.length;
    }

    @Override
    public void writeBytes(byte[] source, int sourceOffset, int length) {
        this.setBytes(this.offset, source, sourceOffset, length);
        this.offset += (long)length;
    }

    @Override
    public void setBytes(long offset, byte[] source) {
        this.setBytes(offset, source, 0, source.length);
    }

    @Override
    public void setBytes(long offset, byte[] sourceArray, int sourceOffset, int length) {
        try (MemorySegment source = MemorySegment.ofArray((byte[])sourceArray);){
            this.segment.asSlice(offset, (long)length).copyFrom(source.asSlice((long)sourceOffset, (long)length));
        }
    }

    @Override
    public String readString(int length, Charset charset) {
        String value = this.getString(this.offset, length, charset);
        this.offset += (long)length;
        return value;
    }

    @Override
    public String getString(long offset, int length, Charset charset) {
        Objects.requireNonNull(charset);
        byte[] encoded = new byte[length];
        this.getBytes(offset, encoded);
        return new String(encoded, charset);
    }

    @Override
    public String readAscii(int length) {
        return this.readString(length, StandardCharsets.US_ASCII);
    }

    @Override
    public String getAscii(long offset, int length) {
        return this.getString(offset, length, StandardCharsets.US_ASCII);
    }

    @Override
    public String readUtf8(int length) {
        return this.readString(length, StandardCharsets.UTF_8);
    }

    @Override
    public String getUtf8(long offset, int length) {
        return this.getString(offset, length, StandardCharsets.UTF_8);
    }

    @Override
    public int writeString(CharSequence sequence, Charset charset) {
        int written = this.setString(this.offset, sequence, charset);
        this.offset += (long)written;
        return written;
    }

    @Override
    public int setString(long offset, CharSequence sequence, Charset charset) {
        Objects.requireNonNull(sequence);
        Objects.requireNonNull(charset);
        byte[] encoded = sequence.toString().getBytes(charset);
        this.setBytes(offset, encoded);
        return encoded.length;
    }

    @Override
    public int writeAscii(CharSequence sequence) {
        return this.writeString(sequence, StandardCharsets.US_ASCII);
    }

    @Override
    public int setAscii(long offset, CharSequence sequence) {
        return this.setString(offset, sequence, StandardCharsets.US_ASCII);
    }

    @Override
    public int writeUtf8(CharSequence sequence) {
        return this.writeString(sequence, StandardCharsets.UTF_8);
    }

    @Override
    public int setUtf8(long offset, CharSequence sequence) {
        return this.setString(offset, sequence, StandardCharsets.UTF_8);
    }

    @Override
    public void copyFrom(MemorySegment source) {
        this.segment.copyFrom(Objects.requireNonNull(source));
    }

    @Override
    public void copyTo(MemorySegment dest) {
        Objects.requireNonNull(dest);
        dest.copyFrom(this.segment);
    }

    @Override
    public void copyTo(Path path) throws IOException {
        Objects.requireNonNull(path);
        try (MemorySegment dest = MemorySegment.mapFile((Path)path, (long)0L, (long)this.size(), (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE);){
            dest.copyFrom(this.segment);
        }
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        byte[] data = this.segment.toByteArray();
        stream.write(data);
    }

    public String toString() {
        return "AbstractCartridge{segment=" + this.segment + ", order=" + this.order + ", offset=" + this.offset + "}";
    }
}

