/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.compression;

import me.hugmanrique.cartage.compression.DecompressionException;

final class GBACompression {
    static void requireTypeByte(int header, byte expected, String name) {
        int actual = header & 0xFF;
        if (actual != expected) {
            throw new DecompressionException("Expected " + expected + " type byte for " + name + "-compressed data, got " + actual);
        }
    }

    static void requireTypeNibble(int header, byte expected, String name) {
        int actual = header >>> 4 & 0xF;
        if (actual != expected) {
            throw new DecompressionException("Expected " + expected + " type nibble for " + name + "-compressed data, got " + actual);
        }
    }

    private GBACompression() {
        throw new AssertionError();
    }
}

