/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.compression;

import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.compression.DecompressionException;
import me.hugmanrique.cartage.compression.Decompressor;
import me.hugmanrique.cartage.compression.GBACompression;

public final class GBADiffUnfilterer
implements Decompressor {
    private static final GBADiffUnfilterer INSTANCE = new GBADiffUnfilterer();
    private static final byte TYPE = 8;
    private static final int DATA_SIZE = 15;
    private static final int DECOMPRESSED_LENGTH = 8;
    private static final int BYTE_DELTAS = 1;
    private static final int SHORT_DELTAS = 2;

    public static GBADiffUnfilterer get() {
        return INSTANCE;
    }

    private GBADiffUnfilterer() {
    }

    @Override
    public byte[] decompress(Cartridge cartridge) throws DecompressionException {
        try {
            int header = cartridge.readInt();
            GBACompression.requireTypeNibble(header, (byte)8, "UnFilter");
            int dataSize = header & 0xF;
            int length = header >>> 8;
            byte[] result = new byte[length];
            switch (dataSize) {
                case 1: {
                    this.decompressByteDeltas(cartridge, result, length);
                    break;
                }
                case 2: {
                    this.decompressShortDeltas(cartridge, result, length);
                    break;
                }
                default: {
                    throw new DecompressionException("Invalid data size " + dataSize + ", expected 1 or 2");
                }
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecompressionException("Got corrupted DiffUnfilter data", e);
        }
    }

    private void decompressByteDeltas(Cartridge source, byte[] dest, int length) {
        byte absolute = 0;
        for (int i = 0; i < length; ++i) {
            byte delta = source.readByte();
            dest[i] = absolute = (byte)(absolute + delta);
        }
    }

    private void decompressShortDeltas(Cartridge source, byte[] dest, int length) {
        short absolute = 0;
        int i = 0;
        while (i < length) {
            short delta = source.readShort();
            absolute = (short)(absolute + delta);
            dest[i++] = (byte)absolute;
            dest[i++] = (byte)(absolute >>> 8);
        }
    }
}

