/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.compression;

import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.compression.DecompressionException;
import me.hugmanrique.cartage.compression.Decompressor;
import me.hugmanrique.cartage.compression.GBACompression;
import me.hugmanrique.cartage.util.NumberUtils;

public final class GBAHuffmanDecompressor
implements Decompressor {
    private static final GBAHuffmanDecompressor INSTANCE = new GBAHuffmanDecompressor();
    private static final byte TYPE = 2;
    private static final int BIT_DEPTH = 15;
    private static final int DECOMPRESSED_LENGTH = 8;
    private static final int CHILD_IS_LEAF = 128;
    private static final int CHILD_OFFSET = 63;
    private static final long ALIGN_BASE_OFFSET = -2L;

    public static GBAHuffmanDecompressor get() {
        return INSTANCE;
    }

    private GBAHuffmanDecompressor() {
    }

    @Override
    public byte[] decompress(Cartridge cartridge) throws DecompressionException {
        try {
            long rootNodeOffset;
            int header = cartridge.readInt();
            GBACompression.requireTypeNibble(header, (byte)2, "HF");
            byte bitDepth = (byte)(header & 0xF);
            if (bitDepth == 0 || !NumberUtils.isPowerOf2(bitDepth)) {
                throw new DecompressionException("Bit depth must be a positive power of 2, got " + bitDepth);
            }
            int length = header >>> 8;
            byte[] result = new byte[length];
            int treeLength = cartridge.readUnsignedByte() + 1 << 1;
            long nodeOffset = rootNodeOffset = cartridge.offset();
            cartridge.skip(treeLength - 1);
            int index = 0;
            byte bitCount = 0;
            block2: while (index < length) {
                int paths = cartridge.readInt();
                for (int i = 31; i >= 0; i = (int)((byte)(i - 1))) {
                    boolean nextIsLeaf;
                    int direction = paths >>> i & 1;
                    byte node = cartridge.getByte(nodeOffset);
                    int nextDelta = (node & 0x3F) + 1 << 1 | direction;
                    nodeOffset = (nodeOffset & 0xFFFFFFFFFFFFFFFEL) + (long)nextDelta;
                    boolean bl = nextIsLeaf = (node << direction & 0x80) != 0;
                    if (!nextIsLeaf) continue;
                    byte value = cartridge.getByte(nodeOffset);
                    result[index] = (byte)(result[index] << bitDepth | value);
                    if ((bitCount = (byte)(bitCount + bitDepth)) == 8) {
                        bitCount = 0;
                        if (++index == length) continue block2;
                    }
                    nodeOffset = rootNodeOffset;
                }
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecompressionException("Got corrupted Huffman-compressed data", e);
        }
    }
}

