/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.compression;

import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.compression.DecompressionException;
import me.hugmanrique.cartage.compression.Decompressor;
import me.hugmanrique.cartage.compression.GBACompression;
import me.hugmanrique.cartage.util.BufferUtils;

public final class GBALZSSDecompressor
implements Decompressor {
    private static final GBALZSSDecompressor INSTANCE = new GBALZSSDecompressor();
    private static final byte TYPE = 16;
    private static final int DECOMPRESSED_LENGTH = 8;
    private static final int BLOCK_COUNT = 8;
    private static final int COMPRESSED = 128;
    private static final int COUNT_BASELINE = 3;
    private static final int DISP_BASELINE = 1;

    public static GBALZSSDecompressor get() {
        return INSTANCE;
    }

    private GBALZSSDecompressor() {
    }

    @Override
    public byte[] decompress(Cartridge cartridge) throws DecompressionException {
        try {
            int header = cartridge.readInt();
            GBACompression.requireTypeByte(header, (byte)16, "LZSS");
            int length = header >>> 8;
            byte[] result = new byte[length];
            int index = 0;
            while (index < length) {
                byte flags = cartridge.readByte();
                int i = 0;
                while (i < 8 && index < length) {
                    boolean compressed;
                    boolean bl = compressed = (flags & 0x80) != 0;
                    if (compressed) {
                        int data = cartridge.readUnsignedShort();
                        int count = Math.min((data >>> 4 & 0xF) + 3, length - index);
                        int displacement = 1 + ((data & 0xF) << 8 | data >>> 8);
                        int srcPos = index - displacement;
                        if (srcPos < 0) {
                            throw new DecompressionException("Invalid displacement " + displacement + " at offset " + (cartridge.offset() - 2L));
                        }
                        BufferUtils.copyByteByByte(result, srcPos, index, count);
                        index += count;
                    } else {
                        result[index++] = cartridge.readByte();
                    }
                    ++i;
                    flags = (byte)(flags << 1);
                }
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecompressionException("Got corrupted LZSS-compressed data", e);
        }
    }
}

