/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.compression;

import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.compression.DecompressionException;
import me.hugmanrique.cartage.compression.Decompressor;
import me.hugmanrique.cartage.compression.GBACompression;
import me.hugmanrique.cartage.util.BufferUtils;

public final class GBALZXDecompressor
implements Decompressor {
    private static final GBALZXDecompressor INSTANCE = new GBALZXDecompressor();
    private static final byte TYPE = 17;
    private static final int DECOMPRESSED_LENGTH = 8;
    private static final int BLOCK_COUNT = 8;
    private static final int COMPRESSED = 128;
    private static final int DATA_TYPE = 12;
    private static final int COUNT_BASELINE_0 = 17;
    private static final int COUNT_BASELINE_1 = 273;
    private static final int DISP_BASELINE = 1;

    public static GBALZXDecompressor get() {
        return INSTANCE;
    }

    private GBALZXDecompressor() {
    }

    @Override
    public byte[] decompress(Cartridge cartridge) throws DecompressionException {
        try {
            int header = cartridge.readInt();
            GBACompression.requireTypeByte(header, (byte)17, "LZX");
            int length = header >>> 8;
            byte[] result = new byte[length];
            int index = 0;
            while (index < length) {
                byte flags = cartridge.readByte();
                int i = 0;
                while (i < 8 && index < length) {
                    boolean compressed;
                    boolean bl = compressed = (flags & 0x80) != 0;
                    if (compressed) {
                        int data = cartridge.readByte() << 8 | cartridge.readUnsignedByte();
                        int type = data >>> 12;
                        int count = (data >>> 12) + (switch (type) {
                            case 0 -> {
                                data = (data & 0xFFF) << 8 | cartridge.readUnsignedByte();
                                yield 17;
                            }
                            case 1 -> {
                                data = (data & 0xFFF) << 16 | cartridge.readUnsignedByte() << 8 | cartridge.readUnsignedByte();
                                yield 273;
                            }
                            default -> 1;
                        });
                        int displacement = (data & 0xFFF) + 1;
                        int srcPos = index - displacement;
                        if (srcPos < 0) {
                            throw new DecompressionException("Invalid displacement " + displacement + " at offset " + cartridge.offset());
                        }
                        BufferUtils.copyByteByByte(result, srcPos, index, count);
                        index += count;
                    } else {
                        result[index++] = cartridge.readByte();
                    }
                    ++i;
                    flags = (byte)(flags << 1);
                }
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecompressionException("Got corrupted LZX-compressed data", e);
        }
    }
}

