/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.compression;

import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.compression.DecompressionException;
import me.hugmanrique.cartage.compression.Decompressor;
import me.hugmanrique.cartage.compression.GBACompression;

public final class GBARLDecompressor
implements Decompressor {
    private static final GBARLDecompressor INSTANCE = new GBARLDecompressor();
    private static final byte TYPE = 48;
    private static final int DECOMPRESSED_LENGTH = 8;
    private static final byte REPEAT_RUN = -128;
    private static final byte RUN_LENGTH = 127;
    private static final int REPEAT_BASELINE = 3;
    private static final int COPY_BASELINE = 1;

    public static GBARLDecompressor get() {
        return INSTANCE;
    }

    private GBARLDecompressor() {
    }

    @Override
    public byte[] decompress(Cartridge cartridge) throws DecompressionException {
        try {
            int header = cartridge.readInt();
            GBACompression.requireTypeByte(header, (byte)48, "RL");
            int length = header >>> 8;
            byte[] result = new byte[length];
            int index = 0;
            while (index < length) {
                byte flag = cartridge.readByte();
                boolean repeat = (flag & 0xFFFFFF80) != 0;
                int runLength = flag & 0x7F;
                if (repeat) {
                    byte value = cartridge.readByte();
                    for (int i = 0; i < runLength + 3; ++i) {
                        result[index++] = value;
                    }
                    continue;
                }
                for (int i = 0; i < runLength + 1; ++i) {
                    result[index++] = cartridge.readByte();
                }
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecompressionException("Got corrupted RL-compressed data", e);
        }
    }
}

