/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.gb;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.gb.GBCartridgeHeaderImpl;
import me.hugmanrique.cartage.gb.GBCartridgeImpl;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface GBCartridge
extends Cartridge {
    public static GBCartridge read(Path path) throws IOException {
        Objects.requireNonNull(path);
        byte[] data = Files.readAllBytes(path);
        return new GBCartridgeImpl(data);
    }

    public static GBCartridge read(InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        byte[] data = stream.readAllBytes();
        return new GBCartridgeImpl(data);
    }

    public Header header();

    public short computeChecksum();

    public static interface Header {
        public static final int LOGO_LENGTH = 48;
        public static final int MIN_ROM_BYTES = 32768;
        public static final int MAX_ROM_BYTES = 0x800000;
        public static final int MAX_RAM_BYTES = 131072;

        public short entryPoint();

        public void setEntryPoint(short var1);

        public static byte[] getValidLogo() {
            return (byte[])GBCartridgeHeaderImpl.VALID_LOGO.clone();
        }

        public byte[] logo();

        public void logo(byte[] var1);

        public void setLogo(byte[] var1);

        public void setValidLogo();

        public String title();

        public void setTitle(String var1);

        public String manufacturer();

        public void setManufacturer(String var1);

        public byte gbc();

        public void setGbc(byte var1);

        public boolean hasColorFunctions();

        public boolean requiresColor();

        public short licensee();

        public void setOldLicensee(byte var1);

        public void setNewLicensee(short var1);

        public byte sgb();

        public void setSgb(byte var1);

        public boolean hasSuperFunctions();

        public @Nullable Type type();

        public void setType(Type var1);

        public byte romSize();

        public int romSizeBytes();

        public void setRomSize(byte var1);

        public byte ramSize();

        public int ramSizeBytes();

        public void setRamSize(byte var1);

        public boolean destination();

        public boolean japaneseDistribution();

        public void setDestination(boolean var1);

        public byte version();

        public void setVersion(byte var1);

        public byte checksum();

        public byte computeChecksum();

        public void setChecksum(byte var1);

        public byte setChecksum();

        public short globalChecksum();

        public void setGlobalChecksum(short var1);
    }

    public static enum Type {
        ROM_ONLY(0),
        MBC1(1),
        MBC1_RAM(2),
        MBC1_RAM_BATTERY(3),
        MBC2(5),
        MBC2_RAM_BATTERY(6),
        ROM_RAM(8),
        ROM_RAM_BATTERY(9),
        MMM01(11),
        MMM01_RAM(12),
        MMM01_RAM_BATTERY(13),
        MBC3_TIMER_BATTERY(15),
        MBC3_RAM_TIMER_BATTERY(16),
        MBC3(17),
        MBC3_RAM(18),
        MBC3_RAM_BATTERY(19),
        MBC5(25),
        MBC5_RAM(26),
        MBC5_RAM_BATTERY(27),
        MBC5_RUMBLE(28),
        MBC5_RAM_RUMBLE(29),
        MBC5_RAM_BATTERY_RUMBLE(30),
        MBC6_RAM_BATTERY(32),
        MBC7_RAM_BATTERY_ACCELEROMETER(34),
        POCKET_CAMERA(252),
        BANDAI_TAMA5(253),
        HUC3(254),
        HUC1_RAM_BATTERY(255);

        private final byte value;

        public static @Nullable Type of(byte value) {
            for (Type type : Type.values()) {
                if (type.value() != value) continue;
                return type;
            }
            return null;
        }

        private Type(int value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }

        public boolean hasMemoryBankController() {
            return this != ROM_ONLY;
        }
    }
}

