/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.gb;

import java.util.Objects;
import me.hugmanrique.cartage.gb.GBCartridge;
import me.hugmanrique.cartage.util.StringUtils;

record GBCartridgeHeaderImpl(GBCartridge cartridge) implements GBCartridge.Header
{
    static final byte[] VALID_LOGO = new byte[]{-50, -19, 102, 102, -52, 13, 0, 11, 3, 115, 0, -125, 0, 12, 0, 13, 0, 8, 17, 31, -120, -119, 0, 14, -36, -52, 110, -26, -35, -35, -39, -103, -69, -69, 103, 99, 110, 14, -20, -52, -35, -36, -103, -97, -69, -71, 51, 62};
    static final int GLOBAL_CHECKSUM_ADDR = 334;
    private static final int ENTRY_POINT_ADDR = 256;
    private static final short JR_BASELINE = 2;
    private static final int LOGO_ADDR = 260;
    private static final int TITLE_ADDR = 308;
    private static final int TITLE_LENGTH = 16;
    private static final int MANUFACTURER_ADDR = 319;
    private static final int MANUFACTURER_LENGTH = 4;
    private static final int GBC_FLAG_ADDR = 323;
    private static final byte SUPPORTS_GBC = -128;
    private static final byte REQUIRES_GBC = -64;
    private static final int SGB_FLAG_ADDR = 326;
    private static final byte SUPPORTS_SGB = 3;
    private static final int OLD_LICENSEE_ADDR = 331;
    private static final byte USE_NEW_LICENSEE = 51;
    private static final int NEW_LICENSEE_ADDR = 324;
    private static final short NEW_LICENSEE_NONE = 0;
    private static final int TYPE_ADDR = 327;
    private static final int ROM_SIZE_ADDR = 328;
    private static final int BASE_ROM_SIZE = 32768;
    private static final int RAM_SIZE_ADDR = 329;
    private static final int DEST_CODE_ADDR = 330;
    private static final int VERSION_ADDR = 332;
    private static final int CHECKSUM_ADDR = 333;
    private static final int CHECKSUM_START = 308;
    private static final int CHECKSUM_END = 332;

    GBCartridgeHeaderImpl(GBCartridge cartridge) {
        this.cartridge = Objects.requireNonNull(cartridge);
    }

    private static String prepareString(String value, int expectedLength) {
        Objects.requireNonNull(value);
        StringUtils.requireMaxLength(value, expectedLength);
        StringUtils.requireUppercaseAscii(value);
        return StringUtils.padEnd(value, expectedLength, '\u0000');
    }

    private static boolean isJumpImmediateOrCallOpcode(int opcode) {
        return switch (opcode) {
            case 194, 195, 196, 202, 204, 205, 210, 212, 216, 220, 226, 234, 242, 250 -> true;
            default -> false;
        };
    }

    private static boolean isJumpRelativeOpcode(int opcode) {
        return switch (opcode) {
            case 24, 32, 40, 48, 56 -> true;
            default -> false;
        };
    }

    @Override
    public short entryPoint() {
        int offset = 256;
        do {
            int opcode;
            if (GBCartridgeHeaderImpl.isJumpImmediateOrCallOpcode(opcode = this.cartridge.getUnsignedByte(offset))) {
                return this.cartridge.getShort(offset + 1);
            }
            if (!GBCartridgeHeaderImpl.isJumpRelativeOpcode(opcode)) continue;
            return (short)(this.cartridge.getByte(offset + 1) + 2);
        } while (offset++ <= 257);
        throw new IllegalStateException("Entry point contains no JP, CALL or JR instruction");
    }

    @Override
    public void setEntryPoint(short entryPoint) {
        this.cartridge.setByte(256L, (byte)0);
        this.cartridge.setByte(257L, (byte)-61);
        this.cartridge.setShort(258L, entryPoint);
    }

    @Override
    public byte[] logo() {
        byte[] bitmap = new byte[48];
        this.logo(bitmap);
        return bitmap;
    }

    @Override
    public void logo(byte[] dest) {
        if (dest.length != 48) {
            throw new IllegalArgumentException("Invalid dest array length " + dest.length);
        }
        this.cartridge.getBytes(260L, dest);
    }

    @Override
    public void setLogo(byte[] source) {
        if (source.length != 48) {
            throw new IllegalArgumentException("Invalid source array length " + source.length);
        }
        this.cartridge.setBytes(260L, source);
    }

    @Override
    public void setValidLogo() {
        this.setLogo(VALID_LOGO);
    }

    @Override
    public String title() {
        return this.cartridge.getAscii(308L, 16);
    }

    @Override
    public void setTitle(String title) {
        this.cartridge.setAscii(308L, GBCartridgeHeaderImpl.prepareString(title, 16));
    }

    @Override
    public String manufacturer() {
        return this.cartridge.getAscii(319L, 4);
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.cartridge.setAscii(319L, GBCartridgeHeaderImpl.prepareString(manufacturer, 4));
    }

    @Override
    public byte gbc() {
        return this.cartridge.getByte(323L);
    }

    @Override
    public void setGbc(byte value) {
        this.cartridge.setByte(323L, value);
    }

    @Override
    public boolean hasColorFunctions() {
        byte gbc = this.gbc();
        return gbc == -128 || gbc == -64;
    }

    @Override
    public boolean requiresColor() {
        return this.gbc() == -64;
    }

    @Override
    public short licensee() {
        byte oldCode = this.cartridge.getByte(331L);
        if (oldCode == 51) {
            return this.cartridge.getShort(324L);
        }
        return oldCode;
    }

    @Override
    public void setOldLicensee(byte licensee) {
        this.cartridge.setByte(331L, licensee);
        this.cartridge.setShort(324L, (short)0);
    }

    @Override
    public void setNewLicensee(short licensee) {
        this.cartridge.setByte(331L, (byte)51);
        this.cartridge.setShort(324L, licensee);
    }

    @Override
    public byte sgb() {
        return this.cartridge.getByte(326L);
    }

    @Override
    public void setSgb(byte value) {
        this.cartridge.setByte(326L, value);
    }

    @Override
    public boolean hasSuperFunctions() {
        return this.sgb() == 3;
    }

    @Override
    public GBCartridge.Type type() {
        byte value = this.cartridge.getByte(327L);
        return GBCartridge.Type.of(value);
    }

    @Override
    public void setType(GBCartridge.Type type) {
        Objects.requireNonNull(type);
        this.cartridge.setByte(327L, type.value());
    }

    @Override
    public byte romSize() {
        return this.cartridge.getByte(328L);
    }

    @Override
    public int romSizeBytes() {
        byte code = this.romSize();
        return switch (code) {
            case 0, 1, 2, 3, 4, 5, 6, 7, 8 -> 32768 << code;
            case 82 -> 0x120000;
            case 83 -> 0x140000;
            case 84 -> 0x180000;
            default -> throw new IllegalArgumentException("Invalid ROM size code " + code);
        };
    }

    @Override
    public void setRomSize(byte code) {
        if (!(code >= 0 && code <= 8 || code >= 82 && code <= 84)) {
            throw new IllegalArgumentException("Invalid ROM size code " + code);
        }
        this.cartridge.setByte(328L, code);
    }

    @Override
    public byte ramSize() {
        return this.cartridge.getByte(329L);
    }

    @Override
    public int ramSizeBytes() {
        byte code = this.ramSize();
        return switch (code) {
            case 0 -> 0;
            case 1 -> 2048;
            case 2 -> 8192;
            case 3 -> 32768;
            case 4 -> 131072;
            case 5 -> 65536;
            default -> throw new IllegalStateException("Invalid RAM size code " + code);
        };
    }

    @Override
    public void setRamSize(byte code) {
        if (code < 0 || code > 5) {
            throw new IllegalArgumentException("Invalid RAM size code " + code);
        }
        this.cartridge.setByte(329L, code);
    }

    @Override
    public boolean destination() {
        return this.cartridge.getByte(330L) == 1;
    }

    @Override
    public boolean japaneseDistribution() {
        return !this.destination();
    }

    @Override
    public void setDestination(boolean destination) {
        byte code = destination ? (byte)1 : 0;
        this.cartridge.setByte(330L, code);
    }

    @Override
    public byte version() {
        return this.cartridge.getByte(332L);
    }

    @Override
    public void setVersion(byte version) {
        this.cartridge.setByte(332L, version);
    }

    @Override
    public byte checksum() {
        return this.cartridge.getByte(333L);
    }

    @Override
    public byte computeChecksum() {
        byte checksum = 0;
        for (int offset = 308; offset <= 332; ++offset) {
            checksum = (byte)(checksum - (byte)(this.cartridge.getByte(offset) + 1));
        }
        return checksum;
    }

    @Override
    public void setChecksum(byte checksum) {
        this.cartridge.setByte(333L, checksum);
    }

    @Override
    public byte setChecksum() {
        byte checksum = this.computeChecksum();
        this.setChecksum(checksum);
        return checksum;
    }

    @Override
    public short globalChecksum() {
        return Short.reverseBytes(this.cartridge.getShort(334L));
    }

    @Override
    public void setGlobalChecksum(short checksum) {
        checksum = Short.reverseBytes(checksum);
        this.cartridge.setShort(334L, checksum);
    }
}

