/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.gb;

import java.nio.ByteOrder;
import java.util.Objects;
import jdk.incubator.foreign.MemorySegment;
import me.hugmanrique.cartage.AbstractCartridge;
import me.hugmanrique.cartage.gb.GBCartridge;
import me.hugmanrique.cartage.gb.GBCartridgeHeaderImpl;

final class GBCartridgeImpl
extends AbstractCartridge
implements GBCartridge {
    private final GBCartridge.Header header = new GBCartridgeHeaderImpl(this);

    GBCartridgeImpl(byte[] data) {
        super(MemorySegment.ofArray((byte[])Objects.requireNonNull(data)), ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public GBCartridge.Header header() {
        return this.header;
    }

    @Override
    public short computeChecksum() {
        int length = this.header.romSizeBytes();
        short checksum = 0;
        for (int i = 0; i < length; ++i) {
            if (i == 334 || i == 335) continue;
            checksum = (short)(checksum + (short)(this.getByte(i) & 0xFF));
        }
        return checksum;
    }
}

