/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.gba;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import me.hugmanrique.cartage.Cartridge;
import me.hugmanrique.cartage.gba.GBACartridgeHeaderImpl;
import me.hugmanrique.cartage.gba.GBACartridgeImpl;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface GBACartridge
extends Cartridge {
    public static GBACartridge read(Path path) throws IOException {
        Objects.requireNonNull(path);
        byte[] data = Files.readAllBytes(path);
        return new GBACartridgeImpl(data);
    }

    public static GBACartridge read(InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        byte[] data = stream.readAllBytes();
        return new GBACartridgeImpl(data);
    }

    public Header header();

    public static interface Header {
        public static final int ENTRY_INSTRUCTION_ADDR = 0x8000000;
        public static final int LOGO_LENGTH = 156;

        public int entryPoint();

        public void setEntryPoint(int var1);

        public static byte[] getValidLogo() {
            return (byte[])GBACartridgeHeaderImpl.VALID_LOGO.clone();
        }

        public byte[] logo();

        public void logo(byte[] var1);

        public void setLogo(byte[] var1);

        public void setValidLogo();

        public String title();

        public void setTitle(String var1);

        public String code();

        public void setCode(String var1);

        public @Nullable Type type();

        public void setType(Type var1);

        public String shortTitle();

        public void setShortTitle(String var1);

        public @Nullable Destination destination();

        public void setDestination(Destination var1);

        public String licensee();

        public void setLicensee(String var1);

        public byte requiredConsole();

        public void setRequiredConsole(byte var1);

        public @Nullable DACSType dacs();

        public void setDacs(DACSType var1);

        public void clearDacs();

        public byte version();

        public void setVersion(byte var1);

        public byte checksum();

        public byte computeChecksum();

        public void setChecksum(byte var1);

        public byte setChecksum();
    }

    public static enum DACSType {
        ONE_MBIT(64, 131072, 167649280),
        EIGHT_MBIT(0, 0x100000, 167755776);

        private final byte value;
        private final int size;
        private final int entryPoint;

        public static @Nullable DACSType of(byte value) {
            for (DACSType type : DACSType.values()) {
                if (type.value() != value) continue;
                return type;
            }
            return null;
        }

        private DACSType(byte value, int size, int entryPoint) {
            this.value = value;
            this.size = size;
            this.entryPoint = entryPoint;
        }

        public byte value() {
            return this.value;
        }

        public int size() {
            return this.size;
        }

        public int entryPoint() {
            return this.entryPoint;
        }
    }

    public static enum Destination {
        JAPAN('J'),
        USA('E'),
        EUROPE('P'),
        GERMANY('D'),
        FRANCE('F'),
        ITALY('I'),
        SPAIN('S');

        private final byte value;

        public static @Nullable Destination of(byte value) {
            for (Destination dest : Destination.values()) {
                if (dest.value() != value) continue;
                return dest;
            }
            return null;
        }

        private Destination(char value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }
    }

    public static enum Type {
        OLD('A'),
        NEW('B'),
        FUTURE('C'),
        NES_EMULATOR('F'),
        ACCELEROMETER('K'),
        E_READER('P'),
        RUMBLE_GYRO('R'),
        RTC_SOLAR('U'),
        RUMBLE('V');

        private final byte value;

        public static @Nullable Type of(byte value) {
            for (Type type : Type.values()) {
                if (type.value() != value) continue;
                return type;
            }
            return null;
        }

        private Type(char value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }
    }
}

