/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.gba;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import me.hugmanrique.cartage.gba.GBACartridge;
import me.hugmanrique.cartage.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

record GBACartridgeHeaderImpl(GBACartridge cartridge) implements GBACartridge.Header
{
    private static final int ENTRY_INSTR_ADDR = 0x8000000;
    private static final int ENTRY_POINT_ADDR = 0;
    private static final int INSTR_LENGTH = 4;
    private static final int BRANCH_OPCODE = 234;
    private static final int MAX_BRANCH_OFFSET = 0x7FFFFF;
    private static final int LOGO_ADDR = 4;
    private static final int LOGO_LENGTH = 156;
    private static final int DEBUG_ENABLE_ADDR = 156;
    private static final byte ENABLE_DEBUG;
    private static final byte DISABLE_DEBUG;
    static final byte[] VALID_LOGO;
    private static final int TITLE_ADDR = 160;
    private static final int TITLE_LENGTH = 12;
    private static final int CODE_ADDR = 172;
    private static final int CODE_LENGTH = 4;
    private static final int TYPE_ADDR = 172;
    private static final int SHORT_TITLE_ADDR = 173;
    private static final int SHORT_TITLE_LENGTH = 2;
    private static final int DEST_ADDR = 175;
    private static final int LICENSEE_ADDR = 176;
    private static final int LICENSEE_LENGTH = 2;
    private static final int REQ_CONSOLE_ADDR = 179;
    private static final int DACS_ADDR = 180;
    private static final int VERSION_ADDR = 188;
    private static final int CHECKSUM_ADDR = 189;
    private static final int CHECKSUM_START = 160;
    private static final int CHECKSUM_END = 188;

    GBACartridgeHeaderImpl(GBACartridge cartridge) {
        this.cartridge = Objects.requireNonNull(cartridge);
    }

    private static String prepareString(String value, int expectedLength, boolean pad) {
        Objects.requireNonNull(value);
        StringUtils.requireUppercaseAscii(value);
        if (pad) {
            StringUtils.requireMaxLength(value, expectedLength);
            return StringUtils.padEnd(value, expectedLength, '\u0000');
        }
        StringUtils.requireLength(value, expectedLength);
        return value;
    }

    private static boolean isBranchInstruction(int instr) {
        return (instr >>> 25 & 7) == 5;
    }

    @Override
    public int entryPoint() {
        int instr = this.cartridge.getInt(0L);
        if (!GBACartridgeHeaderImpl.isBranchInstruction(instr)) {
            throw new IllegalStateException("Entry point instruction is not a B instruction");
        }
        int offset = instr << 8 >> 6;
        return 0x8000000 + offset + 8;
    }

    @Override
    public void setEntryPoint(int address) {
        if ((address & 3) != 0) {
            throw new IllegalArgumentException("Got non-word-aligned address" + address);
        }
        int offset = address - 0x8000000 - 8 >> 2;
        if (Math.abs(offset) > 0x7FFFFF) {
            throw new IllegalArgumentException("Entry point address " + address + " is out of bounds");
        }
        int instr = 0xEA000000 | offset & 0xFFFFFF;
        this.cartridge.setInt(0L, instr);
    }

    @Override
    public byte[] logo() {
        byte[] bitmap = new byte[156];
        this.logo(bitmap);
        return bitmap;
    }

    @Override
    public void logo(byte[] dest) {
        if (dest.length != 156) {
            throw new IllegalArgumentException("Invalid dest array length " + dest.length);
        }
        this.cartridge.getBytes(4L, dest);
    }

    @Override
    public void setLogo(byte[] source) {
        if (source.length != 156) {
            throw new IllegalArgumentException("Invalid source array length " + source.length);
        }
        this.cartridge.setBytes(4L, source);
    }

    @Override
    public void setValidLogo() {
        this.setLogo(VALID_LOGO);
    }

    @Override
    public String title() {
        return this.cartridge.getAscii(160L, 12);
    }

    @Override
    public void setTitle(String title) {
        this.cartridge.setAscii(160L, GBACartridgeHeaderImpl.prepareString(title, 12, true));
    }

    @Override
    public String code() {
        return this.cartridge.getAscii(172L, 4);
    }

    @Override
    public void setCode(String code) {
        this.cartridge.setAscii(172L, GBACartridgeHeaderImpl.prepareString(code, 4, false));
    }

    @Override
    public @Nullable GBACartridge.Type type() {
        byte value = this.cartridge.getByte(172L);
        return GBACartridge.Type.of(value);
    }

    @Override
    public void setType(GBACartridge.Type type) {
        Objects.requireNonNull(type);
        this.cartridge.setByte(172L, type.value());
    }

    @Override
    public String shortTitle() {
        return this.cartridge.getAscii(173L, 2);
    }

    @Override
    public void setShortTitle(String value) {
        this.cartridge.setAscii(173L, GBACartridgeHeaderImpl.prepareString(value, 2, false));
    }

    @Override
    public @Nullable GBACartridge.Destination destination() {
        byte value = this.cartridge.getByte(175L);
        return GBACartridge.Destination.of(value);
    }

    @Override
    public void setDestination(GBACartridge.Destination destination) {
        Objects.requireNonNull(destination);
        this.cartridge.setByte(175L, destination.value());
    }

    @Override
    public String licensee() {
        return this.cartridge.getAscii(176L, 2);
    }

    @Override
    public void setLicensee(String value) {
        this.cartridge.setAscii(176L, GBACartridgeHeaderImpl.prepareString(value, 2, false));
    }

    @Override
    public byte requiredConsole() {
        return this.cartridge.getByte(179L);
    }

    @Override
    public void setRequiredConsole(byte value) {
        this.cartridge.setByte(179L, value);
    }

    @Override
    public @Nullable GBACartridge.DACSType dacs() {
        boolean enabled;
        boolean bl = enabled = this.cartridge.getByte(156L) == ENABLE_DEBUG;
        if (!enabled) {
            return null;
        }
        byte value = this.cartridge.getByte(180L);
        return GBACartridge.DACSType.of(value);
    }

    @Override
    public void setDacs(GBACartridge.DACSType type) {
        Objects.requireNonNull(type);
        this.cartridge.setByte(156L, ENABLE_DEBUG);
        this.cartridge.setByte(180L, type.value());
    }

    @Override
    public void clearDacs() {
        this.cartridge.setByte(156L, DISABLE_DEBUG);
        this.cartridge.setByte(180L, (byte)0);
    }

    @Override
    public byte version() {
        return this.cartridge.getByte(188L);
    }

    @Override
    public void setVersion(byte version) {
        this.cartridge.setByte(188L, version);
    }

    @Override
    public byte checksum() {
        return this.cartridge.getByte(189L);
    }

    @Override
    public byte computeChecksum() {
        int checksum = 0;
        for (int offset = 160; offset <= 188; ++offset) {
            checksum = (byte)(checksum - this.cartridge.getByte(offset));
        }
        return (byte)(checksum - 25);
    }

    @Override
    public void setChecksum(byte checksum) {
        this.cartridge.setByte(189L, checksum);
    }

    @Override
    public byte setChecksum() {
        byte checksum = this.computeChecksum();
        this.setChecksum(checksum);
        return checksum;
    }

    static {
        int[] validLogo = new int[]{620736081, 1771741729, 1032094218, -2065430099, 287607704, -1065255135, -1554858471, -1828073952, 273041994, -131649044, 1489496115, -2098999617, -2047549548, -833943103, -1806267712, 326281212, -1618719373, -1547003295, 1486332711, -66873226, 589154145, 50638422, -1086815232, 1084690173, -11338237, 1872048369, -1745108859, 1624670245, -1453081085, 21903586, -106810113, -1153563836, 2013302987, -2012136812, 1707113571, -2014298961, -702159733, 940223602, 567605255};
        ByteBuffer buffer = ByteBuffer.allocate(156);
        IntBuffer intBuffer = buffer.asIntBuffer();
        intBuffer.put(validLogo);
        VALID_LOGO = buffer.array();
        int debugOffset = 152;
        ENABLE_DEBUG = (byte)(VALID_LOGO[152] & 0x84);
        DISABLE_DEBUG = VALID_LOGO[152];
    }
}

