/*
 * Decompiled with CFR 0.152.
 */
package me.hugmanrique.cartage.util;

import java.util.Objects;

public final class StringUtils {
    public static void requireLength(CharSequence sequence, int length) {
        if (sequence.length() != length) {
            throw new IllegalArgumentException("Expected string length to be " + length + ", got" + sequence.length() + " instead (" + sequence + ")");
        }
    }

    public static void requireMaxLength(CharSequence sequence, int maxLength) {
        if (sequence.length() > maxLength) {
            throw new IllegalArgumentException("Expected string length to be less than " + maxLength + ", got " + sequence.length() + " instead (" + sequence + ")");
        }
    }

    public static void requireUppercaseAscii(String string) {
        StringUtils.requireUppercaseAscii(string, true);
    }

    public static void requireUppercaseAscii(String string, boolean acceptNullTerminators) {
        Objects.requireNonNull(string);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (acceptNullTerminators && c == '\u0000' || c == ' ' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') continue;
            throw new IllegalArgumentException("Expected all-uppercase ASCII string, got " + string);
        }
    }

    public static String padEnd(String string, int length, char padChar) {
        int originalLength = string.length();
        if (originalLength > length) {
            throw new IllegalArgumentException("Cannot pad string with length greater than padded length");
        }
        return string + String.valueOf(padChar).repeat(length - originalLength);
    }

    private StringUtils() {
        throw new AssertionError();
    }
}

