package instep.dao.sql.dialect

import instep.dao.sql.IntegerColumn
import instep.dao.sql.IntegerColumnType
import instep.dao.sql.StringColumn
import java.time.OffsetDateTime


open class HSQLDialect : AbstractDialect() {
    open class ResultSet(private val rs: java.sql.ResultSet) : AbstractDialect.ResultSet(rs) {
        override fun getOffsetDateTime(index: Int): OffsetDateTime? {
            return rs.getObject(index) as? OffsetDateTime
        }

        override fun getOffsetDateTime(label: String): OffsetDateTime? {
            return rs.getObject(label) as? OffsetDateTime
        }
    }

    override fun definitionForUUIDColumn(column: StringColumn): String = "UUID"

    override fun definitionForAutoIncrementColumn(column: IntegerColumn): String = when (column.type) {
        IntegerColumnType.Long -> "BIGINT GENERATED BY DEFAULT AS IDENTITY"
        else -> "INTEGER GENERATED BY DEFAULT AS IDENTITY"
    }
}