/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.dialect;

import instep.ImpossibleBranch;
import instep.InstepLogger;
import instep.dao.PlaceHolder;
import instep.dao.PlaceHolderRemainingException;
import instep.dao.sql.BinaryColumn;
import instep.dao.sql.BooleanColumn;
import instep.dao.sql.Column;
import instep.dao.sql.DateTimeColumn;
import instep.dao.sql.Dialect;
import instep.dao.sql.FloatingColumn;
import instep.dao.sql.InstepSQL;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.Pagination;
import instep.dao.sql.SQLPlan;
import instep.dao.sql.StringColumn;
import instep.dao.sql.dialect.AbstractDialect$WhenMappings;
import instep.dao.sql.dialect.StandardPagination;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J \u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J \u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J.\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u001cH\u0002J&\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u001cH\u0016J&\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u001fH$J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020#H\u0014J\u0014\u0010$\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0014J)\u0010%\u001a\u00020\u00042\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00160&\"\u0006\u0012\u0002\b\u00030\u0016H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u001fH\u0014J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020.H\u0014J\u0010\u00100\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020.H\u0014J \u00101\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J(\u00102\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u00103\u001a\u00020\u0004H\u0016J\u001c\u00104\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0016J\"\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006?"}, d2={"Linstep/dao/sql/dialect/AbstractDialect;", "Linstep/dao/sql/Dialect;", "()V", "defaultInsertValue", "", "getDefaultInsertValue", "()Ljava/lang/String;", "isOffsetDateTimeSupported", "", "()Z", "pagination", "Linstep/dao/sql/Pagination;", "getPagination", "()Linstep/dao/sql/Pagination;", "placeholderForJSONType", "getPlaceholderForJSONType", "placeholderForUUIDType", "getPlaceholderForUUIDType", "addColumn", "Linstep/dao/sql/SQLPlan;", "tableName", "column", "Linstep/dao/sql/Column;", "alterColumnDefault", "alterColumnNotNull", "createTable", "ddl", "columns", "", "createTableIfNotExists", "definitionForAutoIncrementColumn", "Linstep/dao/sql/IntegerColumn;", "definitionForBinaryColumn", "Linstep/dao/sql/BinaryColumn;", "definitionForBooleanColumn", "Linstep/dao/sql/BooleanColumn;", "definitionForColumn", "definitionForColumns", "", "([Linstep/dao/sql/Column;)Ljava/lang/String;", "definitionForDateTimeColumn", "Linstep/dao/sql/DateTimeColumn;", "definitionForFloatingColumn", "Linstep/dao/sql/FloatingColumn;", "definitionForIntegerColumn", "definitionForJSONColumn", "Linstep/dao/sql/StringColumn;", "definitionForStringColumn", "definitionForUUIDColumn", "dropColumn", "renameColumn", "oldName", "renameTable", "newName", "setParameterForPreparedStatement", "", "stmt", "Ljava/sql/PreparedStatement;", "index", "", "value", "", "ResultSet", "dao"})
public abstract class AbstractDialect
implements Dialect {
    @NotNull
    private final String defaultInsertValue = "NULL";
    @NotNull
    private final String placeholderForJSONType = "?";
    @NotNull
    private final String placeholderForUUIDType = "?";
    @NotNull
    private final Pagination pagination = new StandardPagination();
    private final boolean isOffsetDateTimeSupported = true;

    @Override
    @NotNull
    public String getDefaultInsertValue() {
        return this.defaultInsertValue;
    }

    @Override
    @NotNull
    public String getPlaceholderForJSONType() {
        return this.placeholderForJSONType;
    }

    @Override
    @NotNull
    public String getPlaceholderForUUIDType() {
        return this.placeholderForUUIDType;
    }

    @Override
    @NotNull
    public Pagination getPagination() {
        return this.pagination;
    }

    @Override
    public boolean isOffsetDateTimeSupported() {
        return this.isOffsetDateTimeSupported;
    }

    @Override
    @NotNull
    public SQLPlan<?> createTable(@NotNull String tableName, @NotNull List<? extends Column<?>> columns) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        String ddl = "CREATE TABLE " + tableName + " (\n";
        return this.createTable(tableName, ddl, columns);
    }

    @Override
    @NotNull
    public SQLPlan<?> createTableIfNotExists(@NotNull String tableName, @NotNull List<? extends Column<?>> columns) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (\n";
        return this.createTable(tableName, ddl, columns);
    }

    /*
     * WARNING - void declaration
     */
    private final SQLPlan<?> createTable(String tableName, String ddl, List<? extends Column<?>> columns) {
        Column[] columnArray;
        void $receiver$iv;
        if (columns.isEmpty()) {
            Function0 function0 = (Function0)new Function0<String>(tableName){
                final /* synthetic */ String $tableName;

                @NotNull
                public final String invoke() {
                    return "Table " + this.$tableName + " has no columns.";
                }
                {
                    this.$tableName = string;
                    super(0);
                }
            };
            String string = this.getClass().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.javaClass.name");
            InstepLogger.Companion.warning(function0, string);
        }
        Collection collection = columns;
        AbstractDialect abstractDialect = this;
        StringBuilder stringBuilder = new StringBuilder().append(ddl);
        InstepSQL instepSQL = InstepSQL.INSTANCE;
        void v2 = $receiver$iv;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v2;
        Column[] columnArray2 = thisCollection$iv.toArray(new Column[0]);
        if (columnArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Column[] columnArray3 = columnArray = columnArray2;
        return instepSQL.plan(stringBuilder.append(abstractDialect.definitionForColumns(Arrays.copyOf(columnArray3, columnArray3.length))).append("\n)").toString());
    }

    @Override
    @NotNull
    public SQLPlan<?> renameTable(@NotNull String tableName, @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        return InstepSQL.INSTANCE.plan("ALTER TABLE " + tableName + " RENAME TO " + newName);
    }

    @Override
    @NotNull
    public SQLPlan<?> addColumn(@NotNull String tableName, @NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        String columnDefinition = this.definitionForColumns(column);
        return InstepSQL.INSTANCE.plan("ALTER TABLE " + tableName + " ADD COLUMN " + columnDefinition);
    }

    @Override
    @NotNull
    public SQLPlan<?> dropColumn(@NotNull String tableName, @NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        return InstepSQL.INSTANCE.plan("ALTER TABLE " + tableName + " DROP COLUMN " + column.getName());
    }

    @Override
    @NotNull
    public SQLPlan<?> renameColumn(@NotNull String tableName, @NotNull Column<?> column, @NotNull String oldName) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)oldName, (String)"oldName");
        return InstepSQL.INSTANCE.plan("ALTER TABLE " + tableName + " RENAME COLUMN " + oldName + " TO " + column.getName());
    }

    @Override
    @NotNull
    public SQLPlan<?> alterColumnNotNull(@NotNull String tableName, @NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        String txt = "ALTER TABLE " + tableName + " ALTER COLUMN " + column.getName();
        if (column.getNullable()) {
            return InstepSQL.INSTANCE.plan(txt + " DROP NOT NULL");
        }
        return InstepSQL.INSTANCE.plan(txt + " SET NOT NULL");
    }

    @Override
    @NotNull
    public SQLPlan<?> alterColumnDefault(@NotNull String tableName, @NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        String txt = "ALTER TABLE " + tableName + " ALTER COLUMN " + column.getName();
        if (StringsKt.isBlank((CharSequence)column.getDefault())) {
            return InstepSQL.INSTANCE.plan(txt + " DROP DEFAULT");
        }
        return InstepSQL.INSTANCE.plan(txt + " SET DEFAULT " + column.getDefault());
    }

    @Override
    public void setParameterForPreparedStatement(@NotNull PreparedStatement stmt, int index, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)stmt, (String)"stmt");
        Object object = value;
        if (object instanceof Enum) {
            stmt.setString(index, ((Enum)value).name());
        } else {
            if (object instanceof PlaceHolder) {
                throw (Throwable)new PlaceHolderRemainingException((PlaceHolder)value);
            }
            if (object instanceof Boolean) {
                stmt.setBoolean(index, (Boolean)value);
            } else if (object instanceof Character) {
                stmt.setString(index, value.toString());
            } else if (object instanceof String) {
                stmt.setString(index, (String)value);
            } else if (object instanceof Byte) {
                stmt.setByte(index, ((Number)value).byteValue());
            } else if (object instanceof Short) {
                stmt.setShort(index, ((Number)value).shortValue());
            } else if (object instanceof Integer) {
                stmt.setInt(index, ((Number)value).intValue());
            } else if (object instanceof Long) {
                stmt.setLong(index, ((Number)value).longValue());
            } else if (object instanceof BigInteger) {
                stmt.setLong(index, ((BigInteger)value).longValue());
            } else if (object instanceof BigDecimal) {
                stmt.setBigDecimal(index, (BigDecimal)value);
            } else if (object instanceof Float) {
                stmt.setFloat(index, ((Number)value).floatValue());
            } else if (object instanceof Double) {
                stmt.setDouble(index, ((Number)value).doubleValue());
            } else if (object instanceof byte[]) {
                stmt.setBytes(index, (byte[])value);
            } else if (object instanceof Instant) {
                stmt.setTimestamp(index, Timestamp.from((Instant)value));
            } else if (object instanceof LocalDate) {
                stmt.setDate(index, Date.valueOf((LocalDate)value));
            } else if (object instanceof LocalTime) {
                stmt.setTime(index, Time.valueOf((LocalTime)value));
            } else if (object instanceof LocalDateTime) {
                stmt.setTimestamp(index, Timestamp.valueOf((LocalDateTime)value));
            } else if (object instanceof OffsetDateTime) {
                ZonedDateTime zonedDateTime;
                ZonedDateTime $receiver = zonedDateTime = ((OffsetDateTime)value).toZonedDateTime();
                stmt.setTimestamp(index, Timestamp.from(((OffsetDateTime)value).toInstant()), Calendar.getInstance(TimeZone.getTimeZone($receiver.getZone())));
            } else if (object instanceof InputStream) {
                stmt.setBinaryStream(index, (InputStream)value);
            } else if (object instanceof Reader) {
                stmt.setCharacterStream(index, (Reader)value);
            } else {
                stmt.setObject(index, value);
            }
        }
    }

    @NotNull
    protected String definitionForBooleanColumn(@NotNull BooleanColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return "BOOLEAN";
    }

    @NotNull
    protected abstract String definitionForAutoIncrementColumn(@NotNull IntegerColumn var1);

    @NotNull
    protected String definitionForJSONColumn(@NotNull StringColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        throw (Throwable)new NotImplementedError("JSON Column is not supported by " + this.getClass().getSimpleName());
    }

    @NotNull
    protected String definitionForUUIDColumn(@NotNull StringColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        throw (Throwable)new NotImplementedError("UUID Column is not supported by " + this.getClass().getSimpleName());
    }

    @NotNull
    protected String definitionForIntegerColumn(@NotNull IntegerColumn column) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (AbstractDialect$WhenMappings.$EnumSwitchMapping$0[column.getType().ordinal()]) {
            case 1: {
                string = "TINYINT";
                break;
            }
            case 2: {
                string = "SMALLINT";
                break;
            }
            case 3: {
                string = "INTEGER";
                break;
            }
            case 4: {
                string = "BIGINT";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected String definitionForStringColumn(@NotNull StringColumn column) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (AbstractDialect$WhenMappings.$EnumSwitchMapping$1[column.getType().ordinal()]) {
            case 1: {
                string = "CHAR(" + column.getLength() + ')';
                break;
            }
            case 2: {
                string = "VARCHAR(" + column.getLength() + ')';
                break;
            }
            case 3: {
                if (column.getLength() > 0) {
                    string = "TEXT(" + column.getLength() + ')';
                    break;
                }
                string = "TEXT";
                break;
            }
            case 4: {
                string = this.definitionForJSONColumn(column);
                break;
            }
            case 5: {
                string = this.definitionForUUIDColumn(column);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected String definitionForFloatingColumn(@NotNull FloatingColumn column) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (AbstractDialect$WhenMappings.$EnumSwitchMapping$2[column.getType().ordinal()]) {
            case 1: {
                string = "REAL";
                break;
            }
            case 2: {
                string = "DOUBLE";
                break;
            }
            case 3: {
                string = "NUMERIC(" + column.getPrecision() + ',' + column.getScale() + ')';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected String definitionForDateTimeColumn(@NotNull DateTimeColumn column) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (AbstractDialect$WhenMappings.$EnumSwitchMapping$3[column.getType().ordinal()]) {
            case 1: {
                string = "DATE";
                break;
            }
            case 2: {
                string = "TIME";
                break;
            }
            case 3: {
                string = "TIMESTAMP";
                break;
            }
            case 4: {
                string = "TIMESTAMP WITH TIME ZONE";
                break;
            }
            case 5: {
                string = "TIMESTAMP";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected String definitionForBinaryColumn(@NotNull BinaryColumn column) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (AbstractDialect$WhenMappings.$EnumSwitchMapping$4[column.getType().ordinal()]) {
            case 1: {
                if (column.getLength() > 0) {
                    string = "BINARY(" + column.getLength() + ')';
                    break;
                }
                string = "BINARY";
                break;
            }
            case 2: {
                if (column.getLength() > 0) {
                    string = "BLOB(" + column.getLength() + ')';
                    break;
                }
                string = "BLOB";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    protected String definitionForColumn(@NotNull Column<?> column) {
        String string;
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        String txt = '\t' + column.getName();
        StringBuilder stringBuilder = new StringBuilder().append(txt).append(" ");
        Object object = column;
        if (object instanceof BooleanColumn) {
            string = this.definitionForBooleanColumn((BooleanColumn)column);
        } else if (object instanceof StringColumn) {
            string = this.definitionForStringColumn((StringColumn)column);
        } else if (object instanceof IntegerColumn) {
            string = ((IntegerColumn)column).getAutoIncrement() ? this.definitionForAutoIncrementColumn((IntegerColumn)column) : this.definitionForIntegerColumn((IntegerColumn)column);
        } else if (object instanceof FloatingColumn) {
            string = this.definitionForFloatingColumn((FloatingColumn)column);
        } else if (object instanceof DateTimeColumn) {
            string = this.definitionForDateTimeColumn((DateTimeColumn)column);
        } else if (object instanceof BinaryColumn) {
            string = this.definitionForBinaryColumn((BinaryColumn)column);
        } else {
            throw (Throwable)new ImpossibleBranch();
        }
        txt = stringBuilder.append(string).toString();
        if (!column.getNullable()) {
            txt = txt + " NOT NULL";
        }
        if (!StringsKt.isBlank((CharSequence)(object = (CharSequence)column.getDefault()))) {
            txt = txt + " DEFAULT " + column.getDefault();
        }
        if (column.getUnique()) {
            txt = txt + " UNIQUE";
        }
        if (column.getPrimary()) {
            txt = txt + " PRIMARY KEY";
        }
        return txt;
    }

    /*
     * WARNING - void declaration
     */
    private final String definitionForColumns(Column<?> ... columns) {
        void $receiver$iv$iv;
        Column<?>[] $receiver$iv;
        Column<?>[] columnArray = $receiver$iv = columns;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $receiver$iv$iv[i];
            Collection collection = destination$iv$iv;
            String string = this.definitionForColumn((Column<?>)it);
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b4\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\t\u0010\n\u001a\u00020\tH\u0096\u0001J\t\u0010\u000b\u001a\u00020\tH\u0096\u0001J\t\u0010\f\u001a\u00020\tH\u0096\u0001J\t\u0010\r\u001a\u00020\tH\u0096\u0001J\t\u0010\u000e\u001a\u00020\tH\u0096\u0001J\u0019\u0010\u000f\u001a\u00020\u00072\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u0096\u0001J\u0019\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\u00140\u00142\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010\u0015\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010\u0015\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010\u0017\u001a\n \u0011*\u0004\u0018\u00010\u00180\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010\u0017\u001a\n \u0011*\u0004\u0018\u00010\u00180\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0097\u0001J!\u0010\u0017\u001a\n \u0011*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J)\u0010\u0017\u001a\n \u0011*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020\u0007H\u0097\u0001J\u0019\u0010\u001a\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010\u001a\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010\u001b\u001a\n \u0011*\u0004\u0018\u00010\u001c0\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010\u001b\u001a\n \u0011*\u0004\u0018\u00010\u001c0\u001c2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0011\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010\u001d\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010\u001e\u001a\u00020\u001f2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010 \u001a\n \u0011*\u0004\u0018\u00010!0!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010 \u001a\n \u0011*\u0004\u0018\u00010!0!2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010\"\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010\"\u001a\n \u0011*\u0004\u0018\u00010#0#2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010$\u001a\n \u0011*\u0004\u0018\u00010%0%2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010$\u001a\n \u0011*\u0004\u0018\u00010%0%2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\t\u0010&\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010'\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010(\u001a\n \u0011*\u0004\u0018\u00010)0)2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J)\u0010(\u001a\n \u0011*\u0004\u0018\u00010)0)2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001J!\u0010(\u001a\n \u0011*\u0004\u0018\u00010)0)2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J1\u0010(\u001a\n \u0011*\u0004\u0018\u00010)0)2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001J\u0011\u0010+\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010+\u001a\u00020,2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\t\u0010-\u001a\u00020\u0007H\u0096\u0001J\t\u0010.\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010/\u001a\u0002002\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010/\u001a\u0002002\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\t\u00101\u001a\u00020\u0007H\u0096\u0001J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0007H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00105\u001a\u00020\u0010H\u0016J\u0011\u00106\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u00106\u001a\u00020\u00072\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00104\u001a\u00020\u0007H\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00105\u001a\u00020\u0010H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u00104\u001a\u00020\u0007H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u00020\u0010H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00104\u001a\u00020\u0007H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00105\u001a\u00020\u0010H\u0016J\u0011\u0010=\u001a\u00020>2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010=\u001a\u00020>2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0011\u0010?\u001a\n \u0011*\u0004\u0018\u00010@0@H\u0096\u0001J\u0019\u0010A\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010A\u001a\n \u0011*\u0004\u0018\u00010#0#2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010B\u001a\n \u0011*\u0004\u0018\u00010C0C2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010B\u001a\n \u0011*\u0004\u0018\u00010C0C2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010D\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010D\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010E\u001a\n \u0011*\u0004\u0018\u00010F0F2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\\\u0010E\u001a\n \u0011*\u0004\u0018\u0001HGHG\"\u0010\b\u0000\u0010G*\n \u0011*\u0004\u0018\u00010F0F2\u0006\u0010\u0006\u001a\u00020\u00072*\u0010\u0019\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u0001HGHG \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u0001HGHG\u0018\u00010H0HH\u0096\u0001\u00a2\u0006\u0002\u0010IJq\u0010E\u001a\n \u0011*\u0004\u0018\u00010F0F2\u0006\u0010\u0006\u001a\u00020\u00072V\u0010\u0019\u001aR\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0011*\b\u0012\u0002\b\u0003\u0018\u00010H0H \u0011*(\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0011*\b\u0012\u0002\b\u0003\u0018\u00010H0H\u0018\u00010K0JH\u0096\u0001J!\u0010E\u001a\n \u0011*\u0004\u0018\u00010F0F2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001Jd\u0010E\u001a\n \u0011*\u0004\u0018\u0001HGHG\"\u0010\b\u0000\u0010G*\n \u0011*\u0004\u0018\u00010F0F2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102*\u0010\u0019\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u0001HGHG \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u0001HGHG\u0018\u00010H0HH\u0096\u0001\u00a2\u0006\u0002\u0010LJy\u0010E\u001a\n \u0011*\u0004\u0018\u00010F0F2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102V\u0010\u0019\u001aR\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0011*\b\u0012\u0002\b\u0003\u0018\u00010H0H \u0011*(\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0011*\b\u0012\u0002\b\u0003\u0018\u00010H0H\u0018\u00010K0JH\u0096\u0001J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u00104\u001a\u00020\u0007H\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u00105\u001a\u00020\u0010H\u0016J\u0019\u0010O\u001a\n \u0011*\u0004\u0018\u00010P0P2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010O\u001a\n \u0011*\u0004\u0018\u00010P0P2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\t\u0010Q\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010R\u001a\n \u0011*\u0004\u0018\u00010S0S2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010R\u001a\n \u0011*\u0004\u0018\u00010S0S2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010T\u001a\n \u0011*\u0004\u0018\u00010U0U2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010T\u001a\n \u0011*\u0004\u0018\u00010U0U2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0011\u0010V\u001a\u00020W2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010V\u001a\u00020W2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0011\u0010X\u001a\n \u0011*\u0004\u0018\u00010Y0YH\u0096\u0001J\u0019\u0010Z\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010Z\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010[\u001a\n \u0011*\u0004\u0018\u00010\\0\\2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J)\u0010[\u001a\n \u0011*\u0004\u0018\u00010\\0\\2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001J!\u0010[\u001a\n \u0011*\u0004\u0018\u00010\\0\\2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J1\u0010[\u001a\n \u0011*\u0004\u0018\u00010\\0\\2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001J\u0019\u0010]\u001a\n \u0011*\u0004\u0018\u00010^0^2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J)\u0010]\u001a\n \u0011*\u0004\u0018\u00010^0^2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001J!\u0010]\u001a\n \u0011*\u0004\u0018\u00010^0^2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J1\u0010]\u001a\n \u0011*\u0004\u0018\u00010^0^2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001J\t\u0010_\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010`\u001a\n \u0011*\u0004\u0018\u00010a0a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J!\u0010`\u001a\n \u0011*\u0004\u0018\u00010a0a2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0019\u0010b\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0097\u0001J!\u0010b\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0097\u0001J\u0011\u0010c\u001a\n \u0011*\u0004\u0018\u00010d0dH\u0096\u0001J\t\u0010e\u001a\u00020\tH\u0096\u0001J\t\u0010f\u001a\u00020\u0005H\u0096\u0001J\t\u0010g\u001a\u00020\u0005H\u0096\u0001J\t\u0010h\u001a\u00020\u0005H\u0096\u0001J\t\u0010i\u001a\u00020\u0005H\u0096\u0001J\t\u0010j\u001a\u00020\u0005H\u0096\u0001J!\u0010k\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0002\b\u0003 \u0011*\b\u0012\u0002\b\u0003\u0018\u00010H0HH\u0096\u0001J\t\u0010l\u001a\u00020\u0005H\u0096\u0001J\t\u0010m\u001a\u00020\tH\u0096\u0001J\t\u0010n\u001a\u00020\tH\u0096\u0001J\t\u0010o\u001a\u00020\u0005H\u0096\u0003J\t\u0010p\u001a\u00020\u0005H\u0096\u0001J\t\u0010q\u001a\u00020\tH\u0096\u0001J\u0011\u0010r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\t\u0010s\u001a\u00020\u0005H\u0096\u0001J\t\u0010t\u001a\u00020\u0005H\u0096\u0001J\t\u0010u\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010v\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010w\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001JT\u0010x\u001a\n \u0011*\u0004\u0018\u0001HGHG\"\u0010\b\u0000\u0010G*\n \u0011*\u0004\u0018\u00010F0F2*\u0010\u0006\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u0001HGHG \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u0001HGHG\u0018\u00010H0HH\u0096\u0001\u00a2\u0006\u0002\u0010yJ!\u0010z\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J)\u0010z\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J!\u0010{\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J)\u0010{\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J)\u0010{\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020>H\u0096\u0001J)\u0010{\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J1\u0010{\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J1\u0010{\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020>H\u0096\u0001J!\u0010}\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J)\u0010}\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J!\u0010~\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J)\u0010~\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J)\u0010~\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020>H\u0096\u0001J)\u0010~\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J1\u0010~\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J1\u0010~\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020>H\u0096\u0001J!\u0010\u007f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J)\u0010\u007f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020>H\u0096\u0001J!\u0010\u007f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J)\u0010\u007f\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J1\u0010\u007f\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00160\u00162\u0006\u0010|\u001a\u00020>H\u0096\u0001J)\u0010\u007f\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J\u001a\u0010\u0080\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0005H\u0096\u0001J\"\u0010\u0080\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0096\u0001J\u001a\u0010\u0081\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001fH\u0096\u0001J\"\u0010\u0081\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020\u001fH\u0096\u0001J\"\u0010\u0082\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010!0!H\u0096\u0001J*\u0010\u0082\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010!0!H\u0096\u0001J\"\u0010\u0083\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J*\u0010\u0083\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J*\u0010\u0083\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J*\u0010\u0083\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J2\u0010\u0083\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J2\u0010\u0083\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J\"\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J*\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J\"\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010%0%H\u0096\u0001J*\u0010\u0084\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J2\u0010\u0084\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J*\u0010\u0084\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010%0%H\u0096\u0001J\"\u0010\u0085\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010)0)H\u0096\u0001J*\u0010\u0085\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010)0)H\u0096\u0001J\u001a\u0010\u0086\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020,H\u0096\u0001J\"\u0010\u0086\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020,H\u0096\u0001J\u001a\u0010\u0087\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u000200H\u0096\u0001J\"\u0010\u0087\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u000200H\u0096\u0001J\u001a\u0010\u0088\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0096\u0001J\"\u0010\u0088\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020\u0007H\u0096\u0001J\u001a\u0010\u0089\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020>H\u0096\u0001J\"\u0010\u0089\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020>H\u0096\u0001J\"\u0010\u008a\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J*\u0010\u008a\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J*\u0010\u008a\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J2\u0010\u008a\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J\"\u0010\u008b\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J*\u0010\u008b\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J\"\u0010\u008b\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010C0CH\u0096\u0001J*\u0010\u008b\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#H\u0096\u0001J2\u0010\u008b\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010#0#2\u0006\u0010|\u001a\u00020>H\u0096\u0001J*\u0010\u008b\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010C0CH\u0096\u0001J\"\u0010\u008c\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J*\u0010\u008c\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\u0012\u0010\u008d\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u001a\u0010\u008d\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\"\u0010\u008e\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010F0FH\u0096\u0001J*\u0010\u008e\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010F0F2\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J*\u0010\u008e\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010F0FH\u0096\u0001J2\u0010\u008e\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010F0F2\u0006\u0010|\u001a\u00020\u0007H\u0096\u0001J\"\u0010\u008f\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010P0PH\u0096\u0001J*\u0010\u008f\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010P0PH\u0096\u0001J\n\u0010\u0090\u0001\u001a\u00020\tH\u0096\u0001J\"\u0010\u0091\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010S0SH\u0096\u0001J*\u0010\u0091\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010S0SH\u0096\u0001J\"\u0010\u0092\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010U0UH\u0096\u0001J*\u0010\u0092\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010U0UH\u0096\u0001J\u001a\u0010\u0093\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020WH\u0096\u0001J\"\u0010\u0093\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0019\u001a\u00020WH\u0096\u0001J\"\u0010\u0094\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J*\u0010\u0094\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001J\"\u0010\u0095\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\\0\\H\u0096\u0001J*\u0010\u0095\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\\0\\H\u0096\u0001J\"\u0010\u0096\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010^0^H\u0096\u0001J*\u0010\u0096\u0001\u001a\u00020\t2\u000e\u0010\u0006\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00102\u000e\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010^0^H\u0096\u0001J\n\u0010\u0097\u0001\u001a\u00020\u0005H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0098\u0001"}, d2={"Linstep/dao/sql/dialect/AbstractDialect$ResultSet;", "Ljava/sql/ResultSet;", "rs", "(Ljava/sql/ResultSet;)V", "absolute", "", "p0", "", "afterLast", "", "beforeFirst", "cancelRowUpdates", "clearWarnings", "close", "deleteRow", "findColumn", "", "kotlin.jvm.PlatformType", "first", "getArray", "Ljava/sql/Array;", "getAsciiStream", "Ljava/io/InputStream;", "getBigDecimal", "Ljava/math/BigDecimal;", "p1", "getBinaryStream", "getBlob", "Ljava/sql/Blob;", "getBoolean", "getByte", "", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getConcurrency", "getCursorName", "getDate", "Ljava/sql/Date;", "Ljava/util/Calendar;", "getDouble", "", "getFetchDirection", "getFetchSize", "getFloat", "", "getHoldability", "getInstant", "Ljava/time/Instant;", "index", "label", "getInt", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "getMetaData", "Ljava/sql/ResultSetMetaData;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "getObject", "", "T", "Ljava/lang/Class;", "(ILjava/lang/Class;)Ljava/lang/Object;", "", "", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getRef", "Ljava/sql/Ref;", "getRow", "getRowId", "Ljava/sql/RowId;", "getSQLXML", "Ljava/sql/SQLXML;", "getShort", "", "getStatement", "Ljava/sql/Statement;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getType", "getURL", "Ljava/net/URL;", "getUnicodeStream", "getWarnings", "Ljava/sql/SQLWarning;", "insertRow", "isAfterLast", "isBeforeFirst", "isClosed", "isFirst", "isLast", "isWrapperFor", "last", "moveToCurrentRow", "moveToInsertRow", "next", "previous", "refreshRow", "relative", "rowDeleted", "rowInserted", "rowUpdated", "setFetchDirection", "setFetchSize", "unwrap", "(Ljava/lang/Class;)Ljava/lang/Object;", "updateArray", "updateAsciiStream", "p2", "updateBigDecimal", "updateBinaryStream", "updateBlob", "updateBoolean", "updateByte", "updateBytes", "updateCharacterStream", "updateClob", "updateDate", "updateDouble", "updateFloat", "updateInt", "updateLong", "updateNCharacterStream", "updateNClob", "updateNString", "updateNull", "updateObject", "updateRef", "updateRow", "updateRowId", "updateSQLXML", "updateShort", "updateString", "updateTime", "updateTimestamp", "wasNull", "dao"})
    public static class ResultSet
    implements java.sql.ResultSet {
        private final java.sql.ResultSet rs;

        @Nullable
        public Instant getInstant(int index) {
            Instant instant;
            Timestamp timestamp = this.rs.getTimestamp(index);
            if (timestamp != null) {
                Timestamp timestamp2;
                Timestamp p1 = timestamp2 = timestamp;
                instant = p1.toInstant();
            } else {
                instant = null;
            }
            return instant;
        }

        @Nullable
        public Instant getInstant(@NotNull String label) {
            Instant instant;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Timestamp timestamp = this.rs.getTimestamp(label);
            if (timestamp != null) {
                Timestamp timestamp2;
                Timestamp p1 = timestamp2 = timestamp;
                instant = p1.toInstant();
            } else {
                instant = null;
            }
            return instant;
        }

        @Nullable
        public LocalDate getLocalDate(int index) {
            LocalDate localDate;
            Date date = this.rs.getDate(index);
            if (date != null) {
                Date date2;
                Date p1 = date2 = date;
                localDate = p1.toLocalDate();
            } else {
                localDate = null;
            }
            return localDate;
        }

        @Nullable
        public LocalDate getLocalDate(@NotNull String label) {
            LocalDate localDate;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Date date = this.rs.getDate(label);
            if (date != null) {
                Date date2;
                Date p1 = date2 = date;
                localDate = p1.toLocalDate();
            } else {
                localDate = null;
            }
            return localDate;
        }

        @Nullable
        public LocalTime getLocalTime(int index) {
            LocalTime localTime;
            Time time = this.rs.getTime(index);
            if (time != null) {
                Time time2;
                Time p1 = time2 = time;
                localTime = p1.toLocalTime();
            } else {
                localTime = null;
            }
            return localTime;
        }

        @Nullable
        public LocalTime getLocalTime(@NotNull String label) {
            LocalTime localTime;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Time time = this.rs.getTime(label);
            if (time != null) {
                Time time2;
                Time p1 = time2 = time;
                localTime = p1.toLocalTime();
            } else {
                localTime = null;
            }
            return localTime;
        }

        @Nullable
        public LocalDateTime getLocalDateTime(int index) {
            LocalDateTime localDateTime;
            Timestamp timestamp = this.rs.getTimestamp(index);
            if (timestamp != null) {
                Timestamp timestamp2;
                Timestamp p1 = timestamp2 = timestamp;
                localDateTime = p1.toLocalDateTime();
            } else {
                localDateTime = null;
            }
            return localDateTime;
        }

        @Nullable
        public LocalDateTime getLocalDateTime(@NotNull String label) {
            LocalDateTime localDateTime;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Timestamp timestamp = this.rs.getTimestamp(label);
            if (timestamp != null) {
                Timestamp timestamp2;
                Timestamp p1 = timestamp2 = timestamp;
                localDateTime = p1.toLocalDateTime();
            } else {
                localDateTime = null;
            }
            return localDateTime;
        }

        @Nullable
        public OffsetDateTime getOffsetDateTime(int index) {
            return this.rs.getObject(index, OffsetDateTime.class);
        }

        @Nullable
        public OffsetDateTime getOffsetDateTime(@NotNull String label) {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            return this.rs.getObject(label, OffsetDateTime.class);
        }

        public ResultSet(@NotNull java.sql.ResultSet rs) {
            Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
            this.rs = rs;
        }

        @Override
        public boolean absolute(int p0) {
            return this.rs.absolute(p0);
        }

        @Override
        public void afterLast() {
            this.rs.afterLast();
        }

        @Override
        public void beforeFirst() {
            this.rs.beforeFirst();
        }

        @Override
        public void cancelRowUpdates() {
            this.rs.cancelRowUpdates();
        }

        @Override
        public void clearWarnings() {
            this.rs.clearWarnings();
        }

        @Override
        public void close() {
            this.rs.close();
        }

        @Override
        public void deleteRow() {
            this.rs.deleteRow();
        }

        @Override
        public int findColumn(String p0) {
            return this.rs.findColumn(p0);
        }

        @Override
        public boolean first() {
            return this.rs.first();
        }

        @Override
        public Array getArray(int p0) {
            return this.rs.getArray(p0);
        }

        @Override
        public Array getArray(String p0) {
            return this.rs.getArray(p0);
        }

        @Override
        public InputStream getAsciiStream(int p0) {
            return this.rs.getAsciiStream(p0);
        }

        @Override
        public InputStream getAsciiStream(String p0) {
            return this.rs.getAsciiStream(p0);
        }

        @Override
        public BigDecimal getBigDecimal(int p0) {
            return this.rs.getBigDecimal(p0);
        }

        @Override
        @Deprecated(message="Deprecated in Java")
        public BigDecimal getBigDecimal(int p0, int p1) {
            return this.rs.getBigDecimal(p0, p1);
        }

        @Override
        public BigDecimal getBigDecimal(String p0) {
            return this.rs.getBigDecimal(p0);
        }

        @Override
        @Deprecated(message="Deprecated in Java")
        public BigDecimal getBigDecimal(String p0, int p1) {
            return this.rs.getBigDecimal(p0, p1);
        }

        @Override
        public InputStream getBinaryStream(int p0) {
            return this.rs.getBinaryStream(p0);
        }

        @Override
        public InputStream getBinaryStream(String p0) {
            return this.rs.getBinaryStream(p0);
        }

        @Override
        public Blob getBlob(int p0) {
            return this.rs.getBlob(p0);
        }

        @Override
        public Blob getBlob(String p0) {
            return this.rs.getBlob(p0);
        }

        @Override
        public boolean getBoolean(int p0) {
            return this.rs.getBoolean(p0);
        }

        @Override
        public boolean getBoolean(String p0) {
            return this.rs.getBoolean(p0);
        }

        @Override
        public byte getByte(int p0) {
            return this.rs.getByte(p0);
        }

        @Override
        public byte getByte(String p0) {
            return this.rs.getByte(p0);
        }

        @Override
        public byte[] getBytes(int p0) {
            return this.rs.getBytes(p0);
        }

        @Override
        public byte[] getBytes(String p0) {
            return this.rs.getBytes(p0);
        }

        @Override
        public Reader getCharacterStream(int p0) {
            return this.rs.getCharacterStream(p0);
        }

        @Override
        public Reader getCharacterStream(String p0) {
            return this.rs.getCharacterStream(p0);
        }

        @Override
        public Clob getClob(int p0) {
            return this.rs.getClob(p0);
        }

        @Override
        public Clob getClob(String p0) {
            return this.rs.getClob(p0);
        }

        @Override
        public int getConcurrency() {
            return this.rs.getConcurrency();
        }

        @Override
        public String getCursorName() {
            return this.rs.getCursorName();
        }

        @Override
        public Date getDate(int p0) {
            return this.rs.getDate(p0);
        }

        @Override
        public Date getDate(int p0, Calendar p1) {
            return this.rs.getDate(p0, p1);
        }

        @Override
        public Date getDate(String p0) {
            return this.rs.getDate(p0);
        }

        @Override
        public Date getDate(String p0, Calendar p1) {
            return this.rs.getDate(p0, p1);
        }

        @Override
        public double getDouble(int p0) {
            return this.rs.getDouble(p0);
        }

        @Override
        public double getDouble(String p0) {
            return this.rs.getDouble(p0);
        }

        @Override
        public int getFetchDirection() {
            return this.rs.getFetchDirection();
        }

        @Override
        public int getFetchSize() {
            return this.rs.getFetchSize();
        }

        @Override
        public float getFloat(int p0) {
            return this.rs.getFloat(p0);
        }

        @Override
        public float getFloat(String p0) {
            return this.rs.getFloat(p0);
        }

        @Override
        public int getHoldability() {
            return this.rs.getHoldability();
        }

        @Override
        public int getInt(int p0) {
            return this.rs.getInt(p0);
        }

        @Override
        public int getInt(String p0) {
            return this.rs.getInt(p0);
        }

        @Override
        public long getLong(int p0) {
            return this.rs.getLong(p0);
        }

        @Override
        public long getLong(String p0) {
            return this.rs.getLong(p0);
        }

        @Override
        public ResultSetMetaData getMetaData() {
            return this.rs.getMetaData();
        }

        @Override
        public Reader getNCharacterStream(int p0) {
            return this.rs.getNCharacterStream(p0);
        }

        @Override
        public Reader getNCharacterStream(String p0) {
            return this.rs.getNCharacterStream(p0);
        }

        @Override
        public NClob getNClob(int p0) {
            return this.rs.getNClob(p0);
        }

        @Override
        public NClob getNClob(String p0) {
            return this.rs.getNClob(p0);
        }

        @Override
        public String getNString(int p0) {
            return this.rs.getNString(p0);
        }

        @Override
        public String getNString(String p0) {
            return this.rs.getNString(p0);
        }

        @Override
        public Object getObject(int p0) {
            return this.rs.getObject(p0);
        }

        @Override
        public <T> T getObject(int p0, Class<T> p1) {
            return this.rs.getObject(p0, p1);
        }

        @Override
        public Object getObject(int p0, Map<String, Class<?>> p1) {
            return this.rs.getObject(p0, p1);
        }

        @Override
        public Object getObject(String p0) {
            return this.rs.getObject(p0);
        }

        @Override
        public <T> T getObject(String p0, Class<T> p1) {
            return this.rs.getObject(p0, p1);
        }

        @Override
        public Object getObject(String p0, Map<String, Class<?>> p1) {
            return this.rs.getObject(p0, p1);
        }

        @Override
        public Ref getRef(int p0) {
            return this.rs.getRef(p0);
        }

        @Override
        public Ref getRef(String p0) {
            return this.rs.getRef(p0);
        }

        @Override
        public int getRow() {
            return this.rs.getRow();
        }

        @Override
        public RowId getRowId(int p0) {
            return this.rs.getRowId(p0);
        }

        @Override
        public RowId getRowId(String p0) {
            return this.rs.getRowId(p0);
        }

        @Override
        public SQLXML getSQLXML(int p0) {
            return this.rs.getSQLXML(p0);
        }

        @Override
        public SQLXML getSQLXML(String p0) {
            return this.rs.getSQLXML(p0);
        }

        @Override
        public short getShort(int p0) {
            return this.rs.getShort(p0);
        }

        @Override
        public short getShort(String p0) {
            return this.rs.getShort(p0);
        }

        @Override
        public Statement getStatement() {
            return this.rs.getStatement();
        }

        @Override
        public String getString(int p0) {
            return this.rs.getString(p0);
        }

        @Override
        public String getString(String p0) {
            return this.rs.getString(p0);
        }

        @Override
        public Time getTime(int p0) {
            return this.rs.getTime(p0);
        }

        @Override
        public Time getTime(int p0, Calendar p1) {
            return this.rs.getTime(p0, p1);
        }

        @Override
        public Time getTime(String p0) {
            return this.rs.getTime(p0);
        }

        @Override
        public Time getTime(String p0, Calendar p1) {
            return this.rs.getTime(p0, p1);
        }

        @Override
        public Timestamp getTimestamp(int p0) {
            return this.rs.getTimestamp(p0);
        }

        @Override
        public Timestamp getTimestamp(int p0, Calendar p1) {
            return this.rs.getTimestamp(p0, p1);
        }

        @Override
        public Timestamp getTimestamp(String p0) {
            return this.rs.getTimestamp(p0);
        }

        @Override
        public Timestamp getTimestamp(String p0, Calendar p1) {
            return this.rs.getTimestamp(p0, p1);
        }

        @Override
        public int getType() {
            return this.rs.getType();
        }

        @Override
        public URL getURL(int p0) {
            return this.rs.getURL(p0);
        }

        @Override
        public URL getURL(String p0) {
            return this.rs.getURL(p0);
        }

        @Override
        @Deprecated(message="Deprecated in Java")
        public InputStream getUnicodeStream(int p0) {
            return this.rs.getUnicodeStream(p0);
        }

        @Override
        @Deprecated(message="Deprecated in Java")
        public InputStream getUnicodeStream(String p0) {
            return this.rs.getUnicodeStream(p0);
        }

        @Override
        public SQLWarning getWarnings() {
            return this.rs.getWarnings();
        }

        @Override
        public void insertRow() {
            this.rs.insertRow();
        }

        @Override
        public boolean isAfterLast() {
            return this.rs.isAfterLast();
        }

        @Override
        public boolean isBeforeFirst() {
            return this.rs.isBeforeFirst();
        }

        @Override
        public boolean isClosed() {
            return this.rs.isClosed();
        }

        @Override
        public boolean isFirst() {
            return this.rs.isFirst();
        }

        @Override
        public boolean isLast() {
            return this.rs.isLast();
        }

        @Override
        public boolean isWrapperFor(Class<?> p0) {
            return this.rs.isWrapperFor(p0);
        }

        @Override
        public boolean last() {
            return this.rs.last();
        }

        @Override
        public void moveToCurrentRow() {
            this.rs.moveToCurrentRow();
        }

        @Override
        public void moveToInsertRow() {
            this.rs.moveToInsertRow();
        }

        @Override
        public boolean next() {
            return this.rs.next();
        }

        @Override
        public boolean previous() {
            return this.rs.previous();
        }

        @Override
        public void refreshRow() {
            this.rs.refreshRow();
        }

        @Override
        public boolean relative(int p0) {
            return this.rs.relative(p0);
        }

        @Override
        public boolean rowDeleted() {
            return this.rs.rowDeleted();
        }

        @Override
        public boolean rowInserted() {
            return this.rs.rowInserted();
        }

        @Override
        public boolean rowUpdated() {
            return this.rs.rowUpdated();
        }

        @Override
        public void setFetchDirection(int p0) {
            this.rs.setFetchDirection(p0);
        }

        @Override
        public void setFetchSize(int p0) {
            this.rs.setFetchSize(p0);
        }

        @Override
        public <T> T unwrap(Class<T> p0) {
            return this.rs.unwrap(p0);
        }

        @Override
        public void updateArray(int p0, Array p1) {
            this.rs.updateArray(p0, p1);
        }

        @Override
        public void updateArray(String p0, Array p1) {
            this.rs.updateArray(p0, p1);
        }

        @Override
        public void updateAsciiStream(int p0, InputStream p1) {
            this.rs.updateAsciiStream(p0, p1);
        }

        @Override
        public void updateAsciiStream(int p0, InputStream p1, int p2) {
            this.rs.updateAsciiStream(p0, p1, p2);
        }

        @Override
        public void updateAsciiStream(int p0, InputStream p1, long p2) {
            this.rs.updateAsciiStream(p0, p1, p2);
        }

        @Override
        public void updateAsciiStream(String p0, InputStream p1) {
            this.rs.updateAsciiStream(p0, p1);
        }

        @Override
        public void updateAsciiStream(String p0, InputStream p1, int p2) {
            this.rs.updateAsciiStream(p0, p1, p2);
        }

        @Override
        public void updateAsciiStream(String p0, InputStream p1, long p2) {
            this.rs.updateAsciiStream(p0, p1, p2);
        }

        @Override
        public void updateBigDecimal(int p0, BigDecimal p1) {
            this.rs.updateBigDecimal(p0, p1);
        }

        @Override
        public void updateBigDecimal(String p0, BigDecimal p1) {
            this.rs.updateBigDecimal(p0, p1);
        }

        @Override
        public void updateBinaryStream(int p0, InputStream p1) {
            this.rs.updateBinaryStream(p0, p1);
        }

        @Override
        public void updateBinaryStream(int p0, InputStream p1, int p2) {
            this.rs.updateBinaryStream(p0, p1, p2);
        }

        @Override
        public void updateBinaryStream(int p0, InputStream p1, long p2) {
            this.rs.updateBinaryStream(p0, p1, p2);
        }

        @Override
        public void updateBinaryStream(String p0, InputStream p1) {
            this.rs.updateBinaryStream(p0, p1);
        }

        @Override
        public void updateBinaryStream(String p0, InputStream p1, int p2) {
            this.rs.updateBinaryStream(p0, p1, p2);
        }

        @Override
        public void updateBinaryStream(String p0, InputStream p1, long p2) {
            this.rs.updateBinaryStream(p0, p1, p2);
        }

        @Override
        public void updateBlob(int p0, InputStream p1) {
            this.rs.updateBlob(p0, p1);
        }

        @Override
        public void updateBlob(int p0, InputStream p1, long p2) {
            this.rs.updateBlob(p0, p1, p2);
        }

        @Override
        public void updateBlob(int p0, Blob p1) {
            this.rs.updateBlob(p0, p1);
        }

        @Override
        public void updateBlob(String p0, InputStream p1) {
            this.rs.updateBlob(p0, p1);
        }

        @Override
        public void updateBlob(String p0, InputStream p1, long p2) {
            this.rs.updateBlob(p0, p1, p2);
        }

        @Override
        public void updateBlob(String p0, Blob p1) {
            this.rs.updateBlob(p0, p1);
        }

        @Override
        public void updateBoolean(int p0, boolean p1) {
            this.rs.updateBoolean(p0, p1);
        }

        @Override
        public void updateBoolean(String p0, boolean p1) {
            this.rs.updateBoolean(p0, p1);
        }

        @Override
        public void updateByte(int p0, byte p1) {
            this.rs.updateByte(p0, p1);
        }

        @Override
        public void updateByte(String p0, byte p1) {
            this.rs.updateByte(p0, p1);
        }

        @Override
        public void updateBytes(int p0, byte[] p1) {
            this.rs.updateBytes(p0, p1);
        }

        @Override
        public void updateBytes(String p0, byte[] p1) {
            this.rs.updateBytes(p0, p1);
        }

        @Override
        public void updateCharacterStream(int p0, Reader p1) {
            this.rs.updateCharacterStream(p0, p1);
        }

        @Override
        public void updateCharacterStream(int p0, Reader p1, int p2) {
            this.rs.updateCharacterStream(p0, p1, p2);
        }

        @Override
        public void updateCharacterStream(int p0, Reader p1, long p2) {
            this.rs.updateCharacterStream(p0, p1, p2);
        }

        @Override
        public void updateCharacterStream(String p0, Reader p1) {
            this.rs.updateCharacterStream(p0, p1);
        }

        @Override
        public void updateCharacterStream(String p0, Reader p1, int p2) {
            this.rs.updateCharacterStream(p0, p1, p2);
        }

        @Override
        public void updateCharacterStream(String p0, Reader p1, long p2) {
            this.rs.updateCharacterStream(p0, p1, p2);
        }

        @Override
        public void updateClob(int p0, Reader p1) {
            this.rs.updateClob(p0, p1);
        }

        @Override
        public void updateClob(int p0, Reader p1, long p2) {
            this.rs.updateClob(p0, p1, p2);
        }

        @Override
        public void updateClob(int p0, Clob p1) {
            this.rs.updateClob(p0, p1);
        }

        @Override
        public void updateClob(String p0, Reader p1) {
            this.rs.updateClob(p0, p1);
        }

        @Override
        public void updateClob(String p0, Reader p1, long p2) {
            this.rs.updateClob(p0, p1, p2);
        }

        @Override
        public void updateClob(String p0, Clob p1) {
            this.rs.updateClob(p0, p1);
        }

        @Override
        public void updateDate(int p0, Date p1) {
            this.rs.updateDate(p0, p1);
        }

        @Override
        public void updateDate(String p0, Date p1) {
            this.rs.updateDate(p0, p1);
        }

        @Override
        public void updateDouble(int p0, double p1) {
            this.rs.updateDouble(p0, p1);
        }

        @Override
        public void updateDouble(String p0, double p1) {
            this.rs.updateDouble(p0, p1);
        }

        @Override
        public void updateFloat(int p0, float p1) {
            this.rs.updateFloat(p0, p1);
        }

        @Override
        public void updateFloat(String p0, float p1) {
            this.rs.updateFloat(p0, p1);
        }

        @Override
        public void updateInt(int p0, int p1) {
            this.rs.updateInt(p0, p1);
        }

        @Override
        public void updateInt(String p0, int p1) {
            this.rs.updateInt(p0, p1);
        }

        @Override
        public void updateLong(int p0, long p1) {
            this.rs.updateLong(p0, p1);
        }

        @Override
        public void updateLong(String p0, long p1) {
            this.rs.updateLong(p0, p1);
        }

        @Override
        public void updateNCharacterStream(int p0, Reader p1) {
            this.rs.updateNCharacterStream(p0, p1);
        }

        @Override
        public void updateNCharacterStream(int p0, Reader p1, long p2) {
            this.rs.updateNCharacterStream(p0, p1, p2);
        }

        @Override
        public void updateNCharacterStream(String p0, Reader p1) {
            this.rs.updateNCharacterStream(p0, p1);
        }

        @Override
        public void updateNCharacterStream(String p0, Reader p1, long p2) {
            this.rs.updateNCharacterStream(p0, p1, p2);
        }

        @Override
        public void updateNClob(int p0, Reader p1) {
            this.rs.updateNClob(p0, p1);
        }

        @Override
        public void updateNClob(int p0, Reader p1, long p2) {
            this.rs.updateNClob(p0, p1, p2);
        }

        @Override
        public void updateNClob(int p0, NClob p1) {
            this.rs.updateNClob(p0, p1);
        }

        @Override
        public void updateNClob(String p0, Reader p1) {
            this.rs.updateNClob(p0, p1);
        }

        @Override
        public void updateNClob(String p0, Reader p1, long p2) {
            this.rs.updateNClob(p0, p1, p2);
        }

        @Override
        public void updateNClob(String p0, NClob p1) {
            this.rs.updateNClob(p0, p1);
        }

        @Override
        public void updateNString(int p0, String p1) {
            this.rs.updateNString(p0, p1);
        }

        @Override
        public void updateNString(String p0, String p1) {
            this.rs.updateNString(p0, p1);
        }

        @Override
        public void updateNull(int p0) {
            this.rs.updateNull(p0);
        }

        @Override
        public void updateNull(String p0) {
            this.rs.updateNull(p0);
        }

        @Override
        public void updateObject(int p0, Object p1) {
            this.rs.updateObject(p0, p1);
        }

        @Override
        public void updateObject(int p0, Object p1, int p2) {
            this.rs.updateObject(p0, p1, p2);
        }

        @Override
        public void updateObject(String p0, Object p1) {
            this.rs.updateObject(p0, p1);
        }

        @Override
        public void updateObject(String p0, Object p1, int p2) {
            this.rs.updateObject(p0, p1, p2);
        }

        @Override
        public void updateRef(int p0, Ref p1) {
            this.rs.updateRef(p0, p1);
        }

        @Override
        public void updateRef(String p0, Ref p1) {
            this.rs.updateRef(p0, p1);
        }

        @Override
        public void updateRow() {
            this.rs.updateRow();
        }

        @Override
        public void updateRowId(int p0, RowId p1) {
            this.rs.updateRowId(p0, p1);
        }

        @Override
        public void updateRowId(String p0, RowId p1) {
            this.rs.updateRowId(p0, p1);
        }

        @Override
        public void updateSQLXML(int p0, SQLXML p1) {
            this.rs.updateSQLXML(p0, p1);
        }

        @Override
        public void updateSQLXML(String p0, SQLXML p1) {
            this.rs.updateSQLXML(p0, p1);
        }

        @Override
        public void updateShort(int p0, short p1) {
            this.rs.updateShort(p0, p1);
        }

        @Override
        public void updateShort(String p0, short p1) {
            this.rs.updateShort(p0, p1);
        }

        @Override
        public void updateString(int p0, String p1) {
            this.rs.updateString(p0, p1);
        }

        @Override
        public void updateString(String p0, String p1) {
            this.rs.updateString(p0, p1);
        }

        @Override
        public void updateTime(int p0, Time p1) {
            this.rs.updateTime(p0, p1);
        }

        @Override
        public void updateTime(String p0, Time p1) {
            this.rs.updateTime(p0, p1);
        }

        @Override
        public void updateTimestamp(int p0, Timestamp p1) {
            this.rs.updateTimestamp(p0, p1);
        }

        @Override
        public void updateTimestamp(String p0, Timestamp p1) {
            this.rs.updateTimestamp(p0, p1);
        }

        @Override
        public boolean wasNull() {
            return this.rs.wasNull();
        }
    }
}

