/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.dialect;

import instep.dao.DaoException;
import instep.dao.sql.DateTimeColumn;
import instep.dao.sql.DateTimeColumnType;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.StringColumn;
import instep.dao.sql.dialect.AbstractDialect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u000e"}, d2={"Linstep/dao/sql/dialect/H2Dialect;", "Linstep/dao/sql/dialect/AbstractDialect;", "()V", "isOffsetDateTimeSupported", "", "()Z", "definitionForAutoIncrementColumn", "", "column", "Linstep/dao/sql/IntegerColumn;", "definitionForDateTimeColumn", "Linstep/dao/sql/DateTimeColumn;", "definitionForUUIDColumn", "Linstep/dao/sql/StringColumn;", "dao"})
public class H2Dialect
extends AbstractDialect {
    private final boolean isOffsetDateTimeSupported = false;

    @Override
    public boolean isOffsetDateTimeSupported() {
        return this.isOffsetDateTimeSupported;
    }

    @Override
    @NotNull
    protected String definitionForAutoIncrementColumn(@NotNull IntegerColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return "IDENTITY";
    }

    @Override
    @NotNull
    protected String definitionForUUIDColumn(@NotNull StringColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        return "UUID";
    }

    @Override
    @NotNull
    protected String definitionForDateTimeColumn(@NotNull DateTimeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        if (column.getType() == DateTimeColumnType.OffsetDateTime) {
            throw (Throwable)new DaoException("DateTimeColumn.OffsetDateTime is not support", null, 2, null);
        }
        return super.definitionForDateTimeColumn(column);
    }
}

