/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.impl;

import instep.dao.sql.ResultSetValueExtractor;
import instep.dao.sql.dialect.AbstractDialect;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Linstep/dao/sql/impl/DefaultResultSetValueExtractor;", "Linstep/dao/sql/ResultSetValueExtractor;", "()V", "extract", "", "valueType", "Ljava/lang/Class;", "rs", "Linstep/dao/sql/dialect/AbstractDialect$ResultSet;", "colIndex", "", "dao"})
public class DefaultResultSetValueExtractor
implements ResultSetValueExtractor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object extract(@NotNull Class<?> valueType, @NotNull AbstractDialect.ResultSet rs, int colIndex) {
        Object object;
        Intrinsics.checkParameterIsNotNull(valueType, (String)"valueType");
        Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
        Class<?> clazz = valueType;
        if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            object = rs.getBoolean(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Byte.TYPE)) {
            object = rs.getByte(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Short.TYPE)) {
            object = rs.getShort(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            object = rs.getInt(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            object = rs.getLong(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, BigInteger.class)) {
            object = rs.getLong(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, BigDecimal.class)) {
            object = rs.getBigDecimal(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            object = Float.valueOf(rs.getFloat(colIndex));
            return object;
        } else if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            object = rs.getDouble(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Instant.class)) {
            object = rs.getInstant(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, LocalDate.class)) {
            object = rs.getLocalDate(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, LocalTime.class)) {
            object = rs.getLocalTime(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, LocalDateTime.class)) {
            object = rs.getLocalDateTime(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, OffsetDateTime.class)) {
            object = rs.getOffsetDateTime(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, InputStream.class)) {
            object = rs.getBinaryStream(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, byte[].class)) {
            object = rs.getBytes(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, String.class)) {
            object = rs.getString(colIndex);
            return object;
        } else if (Intrinsics.areEqual(clazz, Character.TYPE)) {
            String string;
            String string2 = rs.getString(colIndex);
            Object object2 = string2;
            if (string2 == null) return null;
            String string3 = string = object2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string3.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            object2 = cArray;
            if (cArray == null) return null;
            object = ArraysKt.firstOrNull((char[])object2);
            return object;
        } else {
            object = Intrinsics.areEqual(clazz, InputStream.class) ? rs.getBinaryStream(colIndex) : (Intrinsics.areEqual(clazz, Reader.class) ? rs.getCharacterStream(colIndex) : rs.getObject(colIndex, valueType));
        }
        return object;
    }
}

