/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.dialect;

import instep.dao.DaoException;
import instep.dao.sql.DateTimeColumn;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.dialect.AbstractDialect;
import instep.dao.sql.dialect.CommentInTableDefinitionDialect;
import instep.dao.sql.dialect.MySQLDialect$WhenMappings;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0014J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Linstep/dao/sql/dialect/MySQLDialect;", "Linstep/dao/sql/dialect/CommentInTableDefinitionDialect;", "()V", "offsetDateTimeSupported", "", "getOffsetDateTimeSupported", "()Z", "definitionForAutoIncrementColumn", "", "column", "Linstep/dao/sql/IntegerColumn;", "definitionForDateTimeColumn", "Linstep/dao/sql/DateTimeColumn;", "setParameterForPreparedStatement", "", "stmt", "Ljava/sql/PreparedStatement;", "index", "", "value", "", "ResultSet", "dao"})
public class MySQLDialect
extends CommentInTableDefinitionDialect {
    private final boolean offsetDateTimeSupported = false;

    @Override
    public boolean getOffsetDateTimeSupported() {
        return this.offsetDateTimeSupported;
    }

    @Override
    public void setParameterForPreparedStatement(@NotNull PreparedStatement stmt, int index, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)stmt, (String)"stmt");
        Calendar calendar = Calendar.getInstance();
        Object object = value;
        if (object instanceof Instant) {
            stmt.setTimestamp(index, Timestamp.from((Instant)value), calendar);
        } else if (object instanceof LocalDate) {
            stmt.setDate(index, Date.valueOf((LocalDate)value), calendar);
        } else if (object instanceof LocalTime) {
            stmt.setTime(index, Time.valueOf((LocalTime)value), calendar);
        } else if (object instanceof LocalDateTime) {
            stmt.setTimestamp(index, Timestamp.valueOf((LocalDateTime)value), calendar);
        } else {
            super.setParameterForPreparedStatement(stmt, index, value);
        }
    }

    @Override
    @NotNull
    protected String definitionForAutoIncrementColumn(@NotNull IntegerColumn column) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (MySQLDialect$WhenMappings.$EnumSwitchMapping$0[column.getType().ordinal()]) {
            case 1: {
                string = "BIGINT AUTO_INCREMENT";
                break;
            }
            default: {
                string = "INTEGER AUTO_INCREMENT";
            }
        }
        return string;
    }

    @Override
    @NotNull
    protected String definitionForDateTimeColumn(@NotNull DateTimeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        switch (MySQLDialect$WhenMappings.$EnumSwitchMapping$1[column.getType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw (Throwable)new DaoException("DateTimeColumn.OffsetDateTime is not support", null, 2, null);
            }
            default: {
                return super.definitionForDateTimeColumn(column);
            }
        }
        return "DATETIME";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Linstep/dao/sql/dialect/MySQLDialect$ResultSet;", "Linstep/dao/sql/dialect/AbstractDialect$ResultSet;", "rs", "Ljava/sql/ResultSet;", "(Ljava/sql/ResultSet;)V", "calendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "getInstant", "Ljava/time/Instant;", "index", "", "label", "", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "dao"})
    public static class ResultSet
    extends AbstractDialect.ResultSet {
        private final Calendar calendar;
        private final java.sql.ResultSet rs;

        @Override
        @Nullable
        public Instant getInstant(int index) {
            Instant instant;
            Timestamp timestamp = this.rs.getTimestamp(index, this.calendar);
            if (timestamp != null) {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p1 = timestamp2;
                boolean bl3 = false;
                instant = p1.toInstant();
            } else {
                instant = null;
            }
            return instant;
        }

        @Override
        @Nullable
        public Instant getInstant(@NotNull String label) {
            Instant instant;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Timestamp timestamp = this.rs.getTimestamp(label, this.calendar);
            if (timestamp != null) {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p1 = timestamp2;
                boolean bl3 = false;
                instant = p1.toInstant();
            } else {
                instant = null;
            }
            return instant;
        }

        @Override
        @Nullable
        public LocalDate getLocalDate(int index) {
            LocalDate localDate;
            Date date = this.rs.getDate(index, this.calendar);
            if (date != null) {
                Date date2 = date;
                boolean bl = false;
                boolean bl2 = false;
                Date p1 = date2;
                boolean bl3 = false;
                localDate = p1.toLocalDate();
            } else {
                localDate = null;
            }
            return localDate;
        }

        @Override
        @Nullable
        public LocalDate getLocalDate(@NotNull String label) {
            LocalDate localDate;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Date date = this.rs.getDate(label, this.calendar);
            if (date != null) {
                Date date2 = date;
                boolean bl = false;
                boolean bl2 = false;
                Date p1 = date2;
                boolean bl3 = false;
                localDate = p1.toLocalDate();
            } else {
                localDate = null;
            }
            return localDate;
        }

        @Override
        @Nullable
        public LocalTime getLocalTime(int index) {
            LocalTime localTime;
            Time time = this.rs.getTime(index, this.calendar);
            if (time != null) {
                Time time2 = time;
                boolean bl = false;
                boolean bl2 = false;
                Time p1 = time2;
                boolean bl3 = false;
                localTime = p1.toLocalTime();
            } else {
                localTime = null;
            }
            return localTime;
        }

        @Override
        @Nullable
        public LocalTime getLocalTime(@NotNull String label) {
            LocalTime localTime;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Time time = this.rs.getTime(label, this.calendar);
            if (time != null) {
                Time time2 = time;
                boolean bl = false;
                boolean bl2 = false;
                Time p1 = time2;
                boolean bl3 = false;
                localTime = p1.toLocalTime();
            } else {
                localTime = null;
            }
            return localTime;
        }

        @Override
        @Nullable
        public LocalDateTime getLocalDateTime(int index) {
            LocalDateTime localDateTime;
            Timestamp timestamp = this.rs.getTimestamp(index, this.calendar);
            if (timestamp != null) {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p1 = timestamp2;
                boolean bl3 = false;
                localDateTime = p1.toLocalDateTime();
            } else {
                localDateTime = null;
            }
            return localDateTime;
        }

        @Override
        @Nullable
        public LocalDateTime getLocalDateTime(@NotNull String label) {
            LocalDateTime localDateTime;
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            Timestamp timestamp = this.rs.getTimestamp(label, this.calendar);
            if (timestamp != null) {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p1 = timestamp2;
                boolean bl3 = false;
                localDateTime = p1.toLocalDateTime();
            } else {
                localDateTime = null;
            }
            return localDateTime;
        }

        public ResultSet(@NotNull java.sql.ResultSet rs) {
            Intrinsics.checkParameterIsNotNull((Object)rs, (String)"rs");
            super(rs);
            this.rs = rs;
            this.calendar = Calendar.getInstance(TimeZone.getDefault());
        }
    }
}

