/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql;

import instep.ImpossibleBranch;
import instep.Instep;
import instep.dao.sql.BinaryColumn;
import instep.dao.sql.BinaryColumnType;
import instep.dao.sql.BooleanColumn;
import instep.dao.sql.Column;
import instep.dao.sql.ColumnInfoSetGenerator;
import instep.dao.sql.DateTimeColumn;
import instep.dao.sql.DateTimeColumnType;
import instep.dao.sql.Dialect;
import instep.dao.sql.FloatingColumn;
import instep.dao.sql.FloatingColumnType;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.IntegerColumnType;
import instep.dao.sql.ResultSetDelegate;
import instep.dao.sql.StringColumn;
import instep.dao.sql.Table;
import instep.dao.sql.dialect.AbstractDialect;
import instep.dao.sql.impl.ResultSetColumnInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0011\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u000eH\u0086\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0012H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0014H\u0086\u0002J\u0011\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0016H\u0086\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u0014J\u0010\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\u0002\u0010$J\u0010\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u0010J\u0015\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u0012\u00a2\u0006\u0002\u0010%J\u0015\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\u0014\u00a2\u0006\u0002\u0010&J\u0010\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\u0016J\u0010\u0010'\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\u0012J\u0015\u0010(\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\u0012\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\u0010J\u0010\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\u0010J\u0010\u0010,\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\u0010J\u0015\u0010-\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000b\u001a\u00020\u0014\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u000b\u001a\u00020\u0010J\u000e\u00101\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\u0010J\u001f\u00102\u001a\u0002032\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0086\u0002R \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Linstep/dao/sql/TableRow;", "", "()V", "map", "", "Linstep/dao/sql/Column;", "offset", "Ljava/time/ZoneOffset;", "kotlin.jvm.PlatformType", "get", "Ljava/io/InputStream;", "column", "Linstep/dao/sql/BinaryColumn;", "", "Linstep/dao/sql/BooleanColumn;", "Ljava/time/Instant;", "Linstep/dao/sql/DateTimeColumn;", "", "Linstep/dao/sql/FloatingColumn;", "", "Linstep/dao/sql/IntegerColumn;", "", "Linstep/dao/sql/StringColumn;", "getBigDecimal", "Ljava/math/BigDecimal;", "getFloat", "", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "getNullable", "(Linstep/dao/sql/BooleanColumn;)Ljava/lang/Boolean;", "(Linstep/dao/sql/FloatingColumn;)Ljava/lang/Double;", "(Linstep/dao/sql/IntegerColumn;)Ljava/lang/Integer;", "getNullableBigDecimal", "getNullableFloat", "(Linstep/dao/sql/FloatingColumn;)Ljava/lang/Float;", "getNullableLocalDate", "getNullableLocalDateTime", "getNullableLocalTime", "getNullableLong", "(Linstep/dao/sql/IntegerColumn;)Ljava/lang/Long;", "getNullableOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetDateTime", "set", "", "value", "Companion", "dao"})
public final class TableRow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ZoneOffset offset = OffsetDateTime.now().getOffset();
    @NotNull
    private final Map<Column<?>, Object> map;
    @NotNull
    private static final ResultSetDelegate resultSetDelegate = (ResultSetDelegate)Instep.make$default((Instep)Instep.INSTANCE, ResultSetDelegate.class, null, (int)2, null);
    @NotNull
    private static final ColumnInfoSetGenerator columnInfoSetGenerator = (ColumnInfoSetGenerator)Instep.make$default((Instep)Instep.INSTANCE, ColumnInfoSetGenerator.class, null, (int)2, null);

    public TableRow() {
        boolean bl = false;
        this.map = new LinkedHashMap();
    }

    @Nullable
    public final Object get(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.map.get(column);
    }

    public final boolean get(@NotNull BooleanColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)object;
    }

    public final int get(@NotNull IntegerColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object;
    }

    public final double get(@NotNull FloatingColumn column) {
        double d;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object value = this.map.get(column);
        if (value instanceof Double) {
            d = ((Number)value).doubleValue();
        } else if (value instanceof Float) {
            d = ((Number)value).floatValue();
        } else if (value instanceof BigDecimal) {
            d = ((BigDecimal)value).doubleValue();
        } else {
            throw new UnsupportedOperationException("Converting " + value + " to Double is not supported.");
        }
        return d;
    }

    @NotNull
    public final String get(@NotNull StringColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)object;
    }

    @NotNull
    public final Instant get(@NotNull DateTimeColumn column) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof LocalDateTime) {
            instant = ((LocalDateTime)it).toInstant(this.offset);
        } else if (object2 instanceof Instant) {
            instant = (Instant)it;
        } else if (object2 instanceof OffsetDateTime) {
            instant = ((OffsetDateTime)it).toInstant();
        } else {
            throw new UnsupportedOperationException("Converting " + it + " to Instant is not supported.");
        }
        Instant instant2 = instant;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"map[column].let {\n      \u2026)\n            }\n        }");
        return instant2;
    }

    @NotNull
    public final InputStream get(@NotNull BinaryColumn column) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object value = this.map.get(column);
        if (value instanceof Blob) {
            InputStream inputStream2 = ((Blob)value).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"value.binaryStream");
            inputStream = inputStream2;
        } else if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            boolean bl = false;
            inputStream = new ByteArrayInputStream(byArray);
        } else {
            throw new UnsupportedOperationException("Converting " + value + " to InputStream is not supported.");
        }
        return inputStream;
    }

    public final long getLong(@NotNull IntegerColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
        }
        return (Long)object;
    }

    public final float getFloat(@NotNull FloatingColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        return ((Float)object).floatValue();
    }

    @NotNull
    public final BigDecimal getBigDecimal(@NotNull FloatingColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.math.BigDecimal");
        }
        return (BigDecimal)object;
    }

    @NotNull
    public final LocalDateTime getLocalDateTime(@NotNull DateTimeColumn column) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof LocalDateTime) {
            localDateTime = (LocalDateTime)it;
        } else if (object2 instanceof Instant) {
            localDateTime = LocalDateTime.ofInstant((Instant)it, this.offset);
        } else if (object2 instanceof OffsetDateTime) {
            localDateTime = ((OffsetDateTime)it).toLocalDateTime();
        } else {
            throw new UnsupportedOperationException("Converting " + it + " to LocalDateTime is not supported.");
        }
        LocalDateTime localDateTime2 = localDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"map[column].let {\n      \u2026)\n            }\n        }");
        return localDateTime2;
    }

    @NotNull
    public final OffsetDateTime getOffsetDateTime(@NotNull DateTimeColumn column) {
        OffsetDateTime offsetDateTime;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof LocalDateTime) {
            offsetDateTime = OffsetDateTime.of((LocalDateTime)it, this.offset);
        } else if (object2 instanceof Instant) {
            offsetDateTime = OffsetDateTime.ofInstant((Instant)it, this.offset);
        } else if (object2 instanceof OffsetDateTime) {
            offsetDateTime = (OffsetDateTime)it;
        } else {
            throw new UnsupportedOperationException("Converting " + it + " to OffsetDateTime is not supported.");
        }
        OffsetDateTime offsetDateTime2 = offsetDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"map[column].let {\n      \u2026)\n            }\n        }");
        return offsetDateTime2;
    }

    @NotNull
    public final LocalDate getLocalDate(@NotNull DateTimeColumn column) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof LocalDate) {
            localDate = (LocalDate)it;
        } else if (object2 instanceof LocalDateTime) {
            localDate = ((LocalDateTime)it).toLocalDate();
        } else if (object2 instanceof Instant) {
            localDate = LocalDateTime.ofInstant((Instant)it, this.offset).toLocalDate();
        } else if (object2 instanceof OffsetDateTime) {
            localDate = ((OffsetDateTime)it).toLocalDate();
        } else {
            throw new UnsupportedOperationException("Converting " + it + " to LocalDate is not supported.");
        }
        LocalDate localDate2 = localDate;
        Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"map[column].let {\n      \u2026)\n            }\n        }");
        return localDate2;
    }

    @NotNull
    public final LocalTime getLocalTime(@NotNull DateTimeColumn column) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Object object = this.map.get(column);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof LocalTime) {
            localTime = (LocalTime)it;
        } else if (object2 instanceof LocalDateTime) {
            localTime = ((LocalDateTime)it).toLocalTime();
        } else if (object2 instanceof Instant) {
            localTime = LocalDateTime.ofInstant((Instant)it, this.offset).toLocalTime();
        } else if (object2 instanceof OffsetDateTime) {
            localTime = ((OffsetDateTime)it).toLocalTime();
        } else {
            throw new UnsupportedOperationException("Converting " + it + " to LocalTime is not supported.");
        }
        LocalTime localTime2 = localTime;
        Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"map[column].let {\n      \u2026)\n            }\n        }");
        return localTime2;
    }

    @Nullable
    public final Boolean getNullable(@NotNull BooleanColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.get(column);
        }
        return null;
    }

    @Nullable
    public final Integer getNullable(@NotNull IntegerColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.get(column);
        }
        return null;
    }

    @Nullable
    public final Long getNullableLong(@NotNull IntegerColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.getLong(column);
        }
        return null;
    }

    @Nullable
    public final Double getNullable(@NotNull FloatingColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.get(column);
        }
        return null;
    }

    @Nullable
    public final Float getNullableFloat(@NotNull FloatingColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return Float.valueOf(this.getFloat(column));
        }
        return null;
    }

    @Nullable
    public final BigDecimal getNullableBigDecimal(@NotNull FloatingColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.getBigDecimal(column);
        }
        return null;
    }

    @Nullable
    public final String getNullable(@NotNull StringColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.get(column);
        }
        return null;
    }

    @Nullable
    public final Instant getNullable(@NotNull DateTimeColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.get(column);
        }
        return null;
    }

    @Nullable
    public final LocalDateTime getNullableLocalDateTime(@NotNull DateTimeColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.getLocalDateTime(column);
        }
        return null;
    }

    @Nullable
    public final OffsetDateTime getNullableOffsetDateTime(@NotNull DateTimeColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.getOffsetDateTime(column);
        }
        return null;
    }

    @Nullable
    public final LocalDate getNullableLocalDate(@NotNull DateTimeColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.getLocalDate(column);
        }
        return null;
    }

    @Nullable
    public final LocalTime getNullableLocalTime(@NotNull DateTimeColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.getLocalTime(column);
        }
        return null;
    }

    @Nullable
    public final InputStream getNullable(@NotNull BinaryColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.map.get(column) != null) {
            return this.get(column);
        }
        return null;
    }

    public final void set(@NotNull Column<?> column, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Map<Column<?>, Object> map = this.map;
        boolean bl = false;
        map.put(column, value);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Linstep/dao/sql/TableRow$Companion;", "", "()V", "columnInfoSetGenerator", "Linstep/dao/sql/ColumnInfoSetGenerator;", "getColumnInfoSetGenerator", "()Linstep/dao/sql/ColumnInfoSetGenerator;", "resultSetDelegate", "Linstep/dao/sql/ResultSetDelegate;", "getResultSetDelegate", "()Linstep/dao/sql/ResultSetDelegate;", "createInstance", "Linstep/dao/sql/TableRow;", "T", "Linstep/dao/sql/Table;", "table", "dialect", "Linstep/dao/sql/Dialect;", "resultSet", "Ljava/sql/ResultSet;", "(Linstep/dao/sql/Table;Linstep/dao/sql/Dialect;Ljava/sql/ResultSet;)Linstep/dao/sql/TableRow;", "dao"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResultSetDelegate getResultSetDelegate() {
            return resultSetDelegate;
        }

        @NotNull
        public final ColumnInfoSetGenerator getColumnInfoSetGenerator() {
            return columnInfoSetGenerator;
        }

        @NotNull
        public final <T extends Table> TableRow createInstance(@NotNull T table, @NotNull Dialect dialect, @NotNull ResultSet resultSet) {
            Intrinsics.checkNotNullParameter(table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            TableRow row = new TableRow();
            AbstractDialect.ResultSet rs = this.getResultSetDelegate().getDelegate(dialect, resultSet);
            ColumnInfoSetGenerator columnInfoSetGenerator = this.getColumnInfoSetGenerator();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"rs.metaData");
            Set<ResultSetColumnInfo> columnInfoSet = columnInfoSetGenerator.generate(resultSetMetaData);
            Iterable $this$forEach$iv = table.getColumns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Column col;
                block17: {
                    ResultSetColumnInfo info2;
                    Object object2;
                    int n;
                    Object object3;
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block16: {
                                        Object v1;
                                        block15: {
                                            col = (Column)element$iv;
                                            boolean bl = false;
                                            object3 = columnInfoSet;
                                            n = 0;
                                            Iterable iterable = object3;
                                            boolean bl2 = false;
                                            for (Object t : iterable) {
                                                ResultSetColumnInfo it = (ResultSetColumnInfo)t;
                                                boolean bl3 = false;
                                                if (!StringsKt.equals((String)it.getLabel(), (String)col.getName(), (boolean)true)) continue;
                                                v1 = t;
                                                break block15;
                                            }
                                            v1 = null;
                                        }
                                        object2 = v1;
                                        if (object2 == null) continue;
                                        info2 = object2;
                                        object2 = col;
                                        if (!(object2 instanceof BooleanColumn)) break block16;
                                        object = rs.getBoolean(info2.getIndex());
                                        break block17;
                                    }
                                    if (!(object2 instanceof IntegerColumn)) break block18;
                                    object3 = ((IntegerColumn)col).getType();
                                    n = WhenMappings.$EnumSwitchMapping$0[((Enum)object3).ordinal()];
                                    object = n == 1 ? (Number)rs.getLong(info2.getIndex()) : (Number)rs.getInt(info2.getIndex());
                                    break block17;
                                }
                                if (!(object2 instanceof StringColumn)) break block19;
                                object = rs.getString(info2.getIndex());
                                break block17;
                            }
                            if (!(object2 instanceof FloatingColumn)) break block20;
                            object3 = ((FloatingColumn)col).getType();
                            n = WhenMappings.$EnumSwitchMapping$1[((Enum)object3).ordinal()];
                            switch (n) {
                                case 1: {
                                    object = Float.valueOf(rs.getFloat(info2.getIndex()));
                                    break;
                                }
                                case 2: {
                                    object = rs.getDouble(info2.getIndex());
                                    break;
                                }
                                default: {
                                    object = rs.getBigDecimal(info2.getIndex());
                                    break;
                                }
                            }
                            break block17;
                        }
                        if (!(object2 instanceof DateTimeColumn)) break block21;
                        object3 = ((DateTimeColumn)col).getType();
                        n = WhenMappings.$EnumSwitchMapping$2[((Enum)object3).ordinal()];
                        switch (n) {
                            case 1: {
                                object = rs.getLocalDate(info2.getIndex());
                                break block17;
                            }
                            case 2: {
                                object = rs.getLocalTime(info2.getIndex());
                                break block17;
                            }
                            case 3: {
                                object = rs.getLocalDateTime(info2.getIndex());
                                break block17;
                            }
                            case 4: {
                                object = rs.getOffsetDateTime(info2.getIndex());
                                break block17;
                            }
                            case 5: {
                                object = rs.getInstant(info2.getIndex());
                                break block17;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (object2 instanceof BinaryColumn) {
                        object3 = ((BinaryColumn)col).getType();
                        n = WhenMappings.$EnumSwitchMapping$3[((Enum)object3).ordinal()];
                        object = n == 1 ? rs.getBlob(info2.getIndex()) : (Object)rs.getBytes(info2.getIndex());
                    } else {
                        throw new ImpossibleBranch();
                    }
                }
                row.set(col, object);
            }
            return row;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;

            static {
                int[] nArray = new int[IntegerColumnType.values().length];
                nArray[IntegerColumnType.Long.ordinal()] = 1;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[FloatingColumnType.values().length];
                nArray[FloatingColumnType.Float.ordinal()] = 1;
                nArray[FloatingColumnType.Double.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[DateTimeColumnType.values().length];
                nArray[DateTimeColumnType.Date.ordinal()] = 1;
                nArray[DateTimeColumnType.Time.ordinal()] = 2;
                nArray[DateTimeColumnType.DateTime.ordinal()] = 3;
                nArray[DateTimeColumnType.OffsetDateTime.ordinal()] = 4;
                nArray[DateTimeColumnType.Instant.ordinal()] = 5;
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[BinaryColumnType.values().length];
                nArray[BinaryColumnType.BLOB.ordinal()] = 1;
                $EnumSwitchMapping$3 = nArray;
            }
        }
    }
}

