/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql;

import instep.Instep;
import instep.InstepLogger;
import instep.dao.sql.ConnectionProvider;
import instep.dao.sql.TransactionContext;
import java.sql.Connection;
import java.sql.Savepoint;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0011\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0012\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000fJ4\u0010\u0013\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u0016J*\u0010\u0017\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Linstep/dao/sql/TransactionTemplate;", "", "()V", "logger", "Linstep/InstepLogger;", "threadLocalTransactionContext", "Ljava/lang/ThreadLocal;", "Linstep/dao/sql/TransactionContext;", "getThreadLocalTransactionContext", "()Ljava/lang/ThreadLocal;", "committed", "R", "runner", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "repeatable", "run", "serializable", "template", "level", "", "(Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "uncommitted", "dao"})
public final class TransactionTemplate {
    @NotNull
    public static final TransactionTemplate INSTANCE = new TransactionTemplate();
    @NotNull
    private static final InstepLogger logger = InstepLogger.Companion.getLogger(TransactionTemplate.class);
    @NotNull
    private static final ThreadLocal<TransactionContext> threadLocalTransactionContext = new ThreadLocal<TransactionContext>(){};

    private TransactionTemplate() {
    }

    public final <R> R run(@NotNull Function1<? super TransactionContext, ? extends R> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.template(null, runner);
    }

    public final <R> R uncommitted(@NotNull Function1<? super TransactionContext, ? extends R> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.template(1, runner);
    }

    public final <R> R committed(@NotNull Function1<? super TransactionContext, ? extends R> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.template(2, runner);
    }

    public final <R> R repeatable(@NotNull Function1<? super TransactionContext, ? extends R> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.template(4, runner);
    }

    public final <R> R serializable(@NotNull Function1<? super TransactionContext, ? extends R> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.template(8, runner);
    }

    @NotNull
    public final ThreadLocal<TransactionContext> getThreadLocalTransactionContext() {
        return threadLocalTransactionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R template(@Nullable Integer level, @NotNull Function1<? super TransactionContext, ? extends R> runner) {
        Object connProvider;
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        TransactionContext transactionContext = threadLocalTransactionContext.get();
        if (transactionContext == null) {
            connProvider = (ConnectionProvider)Instep.make$default((Instep)Instep.INSTANCE, ConnectionProvider.class, null, (int)2, null);
            Connection conn = connProvider.getConnection();
            if (level != null) {
                conn.setTransactionIsolation(level);
            }
            conn.setAutoCommit(false);
            transactionContext = new TransactionContext(conn);
        } else {
            if (level != null && level < transactionContext.getConn().getTransactionIsolation()) {
                logger.message("nested transaction isolation level is lesser then outer.").context("nested", (Object)level).context("outer", (Object)transactionContext.getConn().getTransactionIsolation()).warn();
            }
            connProvider = transactionContext;
            ((TransactionContext)connProvider).setDepth(((TransactionContext)connProvider).getDepth() + 1);
        }
        threadLocalTransactionContext.set(transactionContext);
        Connection conn = transactionContext.getConn();
        Savepoint sp = conn.setSavepoint();
        try {
            Object object = transactionContext;
            Object result = runner.invoke(object);
            if (transactionContext.getDepth() > 0) {
                conn.releaseSavepoint(sp);
            } else {
                threadLocalTransactionContext.set(null);
                conn.commit();
            }
            object = result;
            return (R)object;
        }
        catch (Exception e) {
            conn.rollback(sp);
            if (e instanceof TransactionContext.AbortException) {
                if (e.getCause() == null) {
                    R r = null;
                    return r;
                }
                throw e;
            }
            throw new TransactionContext.AbortException(e);
        }
        finally {
            if (transactionContext.getDepth() > 0) {
                TransactionContext transactionContext2 = transactionContext;
                transactionContext2.setDepth(transactionContext2.getDepth() - 1);
            } else {
                threadLocalTransactionContext.set(null);
                conn.close();
            }
        }
    }
}

