/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.dialect;

import instep.dao.DaoException;
import instep.dao.sql.DateTimeColumn;
import instep.dao.sql.DateTimeColumnType;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.IntegerColumnType;
import instep.dao.sql.dialect.AbstractDialect;
import instep.dao.sql.dialect.CommentInTableDefinitionDialect;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Linstep/dao/sql/dialect/MySQLDialect;", "Linstep/dao/sql/dialect/CommentInTableDefinitionDialect;", "()V", "offsetDateTimeSupported", "", "getOffsetDateTimeSupported", "()Z", "returningClauseForInsert", "", "getReturningClauseForInsert", "()Ljava/lang/String;", "definitionForAutoIncrementColumn", "column", "Linstep/dao/sql/IntegerColumn;", "definitionForDateTimeColumn", "Linstep/dao/sql/DateTimeColumn;", "setParameterForPreparedStatement", "", "stmt", "Ljava/sql/PreparedStatement;", "index", "", "value", "", "ResultSet", "dao"})
public class MySQLDialect
extends CommentInTableDefinitionDialect {
    @NotNull
    private final String returningClauseForInsert;
    private final boolean offsetDateTimeSupported;

    public MySQLDialect() {
        this.returningClauseForInsert = "*";
    }

    @Override
    @NotNull
    public String getReturningClauseForInsert() {
        return this.returningClauseForInsert;
    }

    @Override
    public boolean getOffsetDateTimeSupported() {
        return this.offsetDateTimeSupported;
    }

    @Override
    public void setParameterForPreparedStatement(@NotNull PreparedStatement stmt, int index, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Calendar calendar = Calendar.getInstance();
        Object object = value;
        if (object instanceof Instant) {
            stmt.setTimestamp(index, Timestamp.from((Instant)value), calendar);
        } else if (object instanceof LocalDate) {
            stmt.setDate(index, Date.valueOf((LocalDate)value), calendar);
        } else if (object instanceof LocalTime) {
            stmt.setTime(index, Time.valueOf((LocalTime)value), calendar);
        } else if (object instanceof LocalDateTime) {
            stmt.setTimestamp(index, Timestamp.valueOf((LocalDateTime)value), calendar);
        } else {
            super.setParameterForPreparedStatement(stmt, index, value);
        }
    }

    @Override
    @NotNull
    protected String definitionForAutoIncrementColumn(@NotNull IntegerColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        IntegerColumnType integerColumnType = column.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[integerColumnType.ordinal()];
        return n == 1 ? "BIGINT AUTO_INCREMENT" : "INTEGER AUTO_INCREMENT";
    }

    @Override
    @NotNull
    protected String definitionForDateTimeColumn(@NotNull DateTimeColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        DateTimeColumnType dateTimeColumnType = column.getType();
        int n = WhenMappings.$EnumSwitchMapping$1[dateTimeColumnType.ordinal()];
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                throw new DaoException("DateTimeColumn.OffsetDateTime is not support", null, 2, null);
            }
            default: {
                return super.definitionForDateTimeColumn(column);
            }
        }
        return "DATETIME";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Linstep/dao/sql/dialect/MySQLDialect$ResultSet;", "Linstep/dao/sql/dialect/AbstractDialect$ResultSet;", "rs", "Ljava/sql/ResultSet;", "(Ljava/sql/ResultSet;)V", "calendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "getInstant", "Ljava/time/Instant;", "index", "", "label", "", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "dao"})
    public static class ResultSet
    extends AbstractDialect.ResultSet {
        @NotNull
        private final java.sql.ResultSet rs;
        private final Calendar calendar;

        public ResultSet(@NotNull java.sql.ResultSet rs) {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            super(rs);
            this.rs = rs;
            this.calendar = Calendar.getInstance(TimeZone.getDefault());
        }

        @Override
        @Nullable
        public Instant getInstant(int index) {
            Instant instant;
            Timestamp timestamp = this.rs.getTimestamp(index, this.calendar);
            if (timestamp == null) {
                instant = null;
            } else {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p0 = timestamp2;
                boolean bl3 = false;
                instant = p0.toInstant();
            }
            return instant;
        }

        @Override
        @Nullable
        public Instant getInstant(@NotNull String label) {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Timestamp timestamp = this.rs.getTimestamp(label, this.calendar);
            if (timestamp == null) {
                instant = null;
            } else {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p0 = timestamp2;
                boolean bl3 = false;
                instant = p0.toInstant();
            }
            return instant;
        }

        @Override
        @Nullable
        public LocalDate getLocalDate(int index) {
            LocalDate localDate;
            Date date = this.rs.getDate(index, this.calendar);
            if (date == null) {
                localDate = null;
            } else {
                Date date2 = date;
                boolean bl = false;
                boolean bl2 = false;
                Date p0 = date2;
                boolean bl3 = false;
                localDate = p0.toLocalDate();
            }
            return localDate;
        }

        @Override
        @Nullable
        public LocalDate getLocalDate(@NotNull String label) {
            LocalDate localDate;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Date date = this.rs.getDate(label, this.calendar);
            if (date == null) {
                localDate = null;
            } else {
                Date date2 = date;
                boolean bl = false;
                boolean bl2 = false;
                Date p0 = date2;
                boolean bl3 = false;
                localDate = p0.toLocalDate();
            }
            return localDate;
        }

        @Override
        @Nullable
        public LocalTime getLocalTime(int index) {
            LocalTime localTime;
            Time time = this.rs.getTime(index, this.calendar);
            if (time == null) {
                localTime = null;
            } else {
                Time time2 = time;
                boolean bl = false;
                boolean bl2 = false;
                Time p0 = time2;
                boolean bl3 = false;
                localTime = p0.toLocalTime();
            }
            return localTime;
        }

        @Override
        @Nullable
        public LocalTime getLocalTime(@NotNull String label) {
            LocalTime localTime;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Time time = this.rs.getTime(label, this.calendar);
            if (time == null) {
                localTime = null;
            } else {
                Time time2 = time;
                boolean bl = false;
                boolean bl2 = false;
                Time p0 = time2;
                boolean bl3 = false;
                localTime = p0.toLocalTime();
            }
            return localTime;
        }

        @Override
        @Nullable
        public LocalDateTime getLocalDateTime(int index) {
            LocalDateTime localDateTime;
            Timestamp timestamp = this.rs.getTimestamp(index, this.calendar);
            if (timestamp == null) {
                localDateTime = null;
            } else {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p0 = timestamp2;
                boolean bl3 = false;
                localDateTime = p0.toLocalDateTime();
            }
            return localDateTime;
        }

        @Override
        @Nullable
        public LocalDateTime getLocalDateTime(@NotNull String label) {
            LocalDateTime localDateTime;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Timestamp timestamp = this.rs.getTimestamp(label, this.calendar);
            if (timestamp == null) {
                localDateTime = null;
            } else {
                Timestamp timestamp2 = timestamp;
                boolean bl = false;
                boolean bl2 = false;
                Timestamp p0 = timestamp2;
                boolean bl3 = false;
                localDateTime = p0.toLocalDateTime();
            }
            return localDateTime;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IntegerColumnType.values().length];
            nArray[IntegerColumnType.Long.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DateTimeColumnType.values().length];
            nArray[DateTimeColumnType.DateTime.ordinal()] = 1;
            nArray[DateTimeColumnType.OffsetDateTime.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

