/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.dialect;

import instep.dao.sql.BinaryColumn;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.IntegerColumnType;
import instep.dao.sql.StringColumn;
import instep.dao.sql.dialect.AbstractDialect;
import instep.dao.sql.dialect.SeparateCommentDialect;
import java.io.InputStream;
import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0017H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001a"}, d2={"Linstep/dao/sql/dialect/PostgreSQLDialect;", "Linstep/dao/sql/dialect/SeparateCommentDialect;", "()V", "defaultValueForInsert", "", "getDefaultValueForInsert", "()Ljava/lang/String;", "offsetDateTimeSupported", "", "getOffsetDateTimeSupported", "()Z", "placeholderForJSONType", "getPlaceholderForJSONType", "placeholderForUUIDType", "getPlaceholderForUUIDType", "returningClauseForInsert", "getReturningClauseForInsert", "definitionForAutoIncrementColumn", "column", "Linstep/dao/sql/IntegerColumn;", "definitionForBinaryColumn", "Linstep/dao/sql/BinaryColumn;", "definitionForJSONColumn", "Linstep/dao/sql/StringColumn;", "definitionForUUIDColumn", "ResultSet", "dao"})
public class PostgreSQLDialect
extends SeparateCommentDialect {
    @NotNull
    private final String returningClauseForInsert;
    private final boolean offsetDateTimeSupported;
    @NotNull
    private final String placeholderForJSONType;
    @NotNull
    private final String placeholderForUUIDType;
    @NotNull
    private final String defaultValueForInsert;

    public PostgreSQLDialect() {
        this.returningClauseForInsert = "RETURNING *";
        this.placeholderForJSONType = "?::JSONB";
        this.placeholderForUUIDType = "?::UUID";
        this.defaultValueForInsert = "DEFAULT";
    }

    @Override
    @NotNull
    public String getReturningClauseForInsert() {
        return this.returningClauseForInsert;
    }

    @Override
    public boolean getOffsetDateTimeSupported() {
        return this.offsetDateTimeSupported;
    }

    @Override
    @NotNull
    protected String definitionForAutoIncrementColumn(@NotNull IntegerColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        IntegerColumnType integerColumnType = column.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[integerColumnType.ordinal()];
        return n == 1 ? "BIGSERIAL" : "SERIAL";
    }

    @Override
    @NotNull
    public String getPlaceholderForJSONType() {
        return this.placeholderForJSONType;
    }

    @Override
    @NotNull
    public String getPlaceholderForUUIDType() {
        return this.placeholderForUUIDType;
    }

    @Override
    @NotNull
    public String getDefaultValueForInsert() {
        return this.defaultValueForInsert;
    }

    @Override
    @NotNull
    protected String definitionForUUIDColumn(@NotNull StringColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return "UUID";
    }

    @Override
    @NotNull
    protected String definitionForJSONColumn(@NotNull StringColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return "JSONB";
    }

    @Override
    @NotNull
    protected String definitionForBinaryColumn(@NotNull BinaryColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return "BYTEA";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Linstep/dao/sql/dialect/PostgreSQLDialect$ResultSet;", "Linstep/dao/sql/dialect/AbstractDialect$ResultSet;", "rs", "Ljava/sql/ResultSet;", "(Ljava/sql/ResultSet;)V", "getBlob", "Ljava/sql/Blob;", "columnIndex", "", "dao"})
    public static final class ResultSet
    extends AbstractDialect.ResultSet {
        @NotNull
        private final java.sql.ResultSet rs;

        public ResultSet(@NotNull java.sql.ResultSet rs) {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            super(rs);
            this.rs = rs;
        }

        @Override
        @Nullable
        public Blob getBlob(int columnIndex) {
            InputStream inputStream = this.rs.getBinaryStream(columnIndex);
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            return new SerialBlob(stream.readAllBytes());
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IntegerColumnType.values().length];
            nArray[IntegerColumnType.Long.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

