/*
 * Decompiled with CFR 0.152.
 */
package instep.dao.sql.dialect;

import instep.InstepLogger;
import instep.dao.sql.BinaryColumn;
import instep.dao.sql.BinaryColumnType;
import instep.dao.sql.BooleanColumn;
import instep.dao.sql.Column;
import instep.dao.sql.Condition;
import instep.dao.sql.DateTimeColumn;
import instep.dao.sql.DateTimeColumnType;
import instep.dao.sql.InstepSQL;
import instep.dao.sql.IntegerColumn;
import instep.dao.sql.IntegerColumnType;
import instep.dao.sql.SQLPlan;
import instep.dao.sql.SQLPlanExtensionsKt;
import instep.dao.sql.StringColumn;
import instep.dao.sql.Table;
import instep.dao.sql.dialect.AbstractDialect;
import instep.dao.sql.dialect.SeparateCommentDialect;
import instep.dao.sql.dialect.StandardPagination;
import instep.dao.sql.impl.DefaultSQLPlan;
import instep.dao.sql.impl.DefaultTableSelectPlan;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import microsoft.sql.DateTimeOffset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0003#$%B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J6\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0016H\u0014J.\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020!H\u0014J \u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Linstep/dao/sql/dialect/SQLServerDialect;", "Linstep/dao/sql/dialect/SeparateCommentDialect;", "()V", "logger", "Linstep/InstepLogger;", "pagination", "Linstep/dao/sql/Pagination;", "getPagination", "()Linstep/dao/sql/Pagination;", "returningClauseForInsert", "", "getReturningClauseForInsert", "()Ljava/lang/String;", "addColumn", "Linstep/dao/sql/SQLPlan;", "tableName", "column", "Linstep/dao/sql/Column;", "createTable", "tableComment", "ddl", "columns", "", "createTableIfNotExists", "definitionForAutoIncrementColumn", "Linstep/dao/sql/IntegerColumn;", "definitionForBinaryColumn", "Linstep/dao/sql/BinaryColumn;", "definitionForBooleanColumn", "Linstep/dao/sql/BooleanColumn;", "definitionForDateTimeColumn", "Linstep/dao/sql/DateTimeColumn;", "definitionForUUIDColumn", "Linstep/dao/sql/StringColumn;", "dropColumn", "Pagination", "ResultSet", "SelectPlan", "dao"})
public class SQLServerDialect
extends SeparateCommentDialect {
    @NotNull
    private final String returningClauseForInsert;
    @NotNull
    private final InstepLogger logger = InstepLogger.Companion.getLogger(SQLServerDialect.class);

    public SQLServerDialect() {
        this.returningClauseForInsert = "";
    }

    @Override
    @NotNull
    public String getReturningClauseForInsert() {
        return this.returningClauseForInsert;
    }

    @Override
    @NotNull
    public instep.dao.sql.Pagination getPagination() {
        return new Pagination();
    }

    @Override
    @NotNull
    public SQLPlan<?> addColumn(@NotNull String tableName, @NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Column[] columnArray = new Column[]{column};
        String columnDefinition = this.definitionForColumns(columnArray);
        return InstepSQL.INSTANCE.plan("ALTER TABLE " + tableName + " ADD " + columnDefinition);
    }

    @Override
    @NotNull
    public SQLPlan<?> dropColumn(@NotNull String tableName, @NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return InstepSQL.INSTANCE.plan("ALTER TABLE " + tableName + " DROP " + column.getName());
    }

    @Override
    @NotNull
    protected String definitionForBooleanColumn(@NotNull BooleanColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return "BIT";
    }

    @Override
    @NotNull
    protected String definitionForAutoIncrementColumn(@NotNull IntegerColumn column) {
        String string;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        IntegerColumnType integerColumnType = column.getType();
        int n = WhenMappings.$EnumSwitchMapping$0[integerColumnType.ordinal()];
        switch (n) {
            case 1: {
                string = "BIGINT IDENTITY";
                break;
            }
            case 2: {
                string = "INT IDENTITY";
                break;
            }
            case 3: {
                string = "SMALLINT IDENTITY";
                break;
            }
            case 4: {
                string = "TINYINT IDENTITY";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    protected String definitionForDateTimeColumn(@NotNull DateTimeColumn column) {
        String string;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        DateTimeColumnType dateTimeColumnType = column.getType();
        int n = WhenMappings.$EnumSwitchMapping$1[dateTimeColumnType.ordinal()];
        switch (n) {
            case 1: {
                string = "DATETIME2";
                break;
            }
            case 2: {
                string = "DATETIME2";
                break;
            }
            case 3: {
                string = "DATETIMEOFFSET";
                break;
            }
            default: {
                string = super.definitionForDateTimeColumn(column);
            }
        }
        return string;
    }

    @Override
    @NotNull
    protected String definitionForBinaryColumn(@NotNull BinaryColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        BinaryColumnType binaryColumnType = column.getType();
        int n = WhenMappings.$EnumSwitchMapping$2[binaryColumnType.ordinal()];
        return n == 1 ? "VARBINARY(MAX)" : super.definitionForBinaryColumn(column);
    }

    @Override
    @NotNull
    protected String definitionForUUIDColumn(@NotNull StringColumn column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return "UNIQUEIDENTIFIER";
    }

    @Override
    @NotNull
    public SQLPlan<?> createTableIfNotExists(@NotNull String tableName, @NotNull String tableComment, @NotNull List<? extends Column<?>> columns) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)tableComment, (String)"tableComment");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        DefaultSQLPlan existsTableCheck = new DefaultSQLPlan("SELECT name FROM sys.tables WHERE name=${name}").addParameter("name", tableName);
        String existsTableName = SQLPlanExtensionsKt.executeScalar(existsTableCheck);
        if (Intrinsics.areEqual((Object)tableName, (Object)existsTableName)) {
            return existsTableCheck;
        }
        String ddl = "CREATE TABLE " + tableName + " (\n";
        return this.createTable(tableName, tableComment, ddl, columns);
    }

    @Override
    @NotNull
    protected SQLPlan<?> createTable(@NotNull String tableName, @NotNull String tableComment, @NotNull String ddl, @NotNull List<? extends Column<?>> columns) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)tableComment, (String)"tableComment");
        Intrinsics.checkNotNullParameter((Object)ddl, (String)"ddl");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (columns.isEmpty()) {
            this.logger.message("Table has no columns.").context("table", (Object)tableName).warn();
        }
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Column[] columnArray = thisCollection$iv.toArray(new Column[0]);
        if (columnArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Column[] columnArray2 = columnArray;
        return InstepSQL.INSTANCE.plan(ddl + this.definitionForColumns(Arrays.copyOf(columnArray2, columnArray2.length)) + "\n)");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Linstep/dao/sql/dialect/SQLServerDialect$ResultSet;", "Linstep/dao/sql/dialect/AbstractDialect$ResultSet;", "rs", "Ljava/sql/ResultSet;", "(Ljava/sql/ResultSet;)V", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "index", "", "label", "", "dao"})
    public static final class ResultSet
    extends AbstractDialect.ResultSet {
        @NotNull
        private final java.sql.ResultSet rs;

        public ResultSet(@NotNull java.sql.ResultSet rs) {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            super(rs);
            this.rs = rs;
        }

        @Override
        @Nullable
        public OffsetDateTime getOffsetDateTime(int index) {
            Object object = this.rs.getObject(index);
            DateTimeOffset dateTimeOffset = object instanceof DateTimeOffset ? (DateTimeOffset)object : null;
            return dateTimeOffset == null ? null : dateTimeOffset.getOffsetDateTime();
        }

        @Override
        @Nullable
        public OffsetDateTime getOffsetDateTime(@NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Object object = this.rs.getObject(label);
            DateTimeOffset dateTimeOffset = object instanceof DateTimeOffset ? (DateTimeOffset)object : null;
            return dateTimeOffset == null ? null : dateTimeOffset.getOffsetDateTime();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Linstep/dao/sql/dialect/SQLServerDialect$SelectPlan;", "Linstep/dao/sql/impl/DefaultTableSelectPlan;", "from", "Linstep/dao/sql/Table;", "(Linstep/dao/sql/Table;)V", "noOrderByButRowsLimited", "", "getNoOrderByButRowsLimited", "()Z", "parameters", "", "", "getParameters", "()Ljava/util/List;", "selectWords", "", "getSelectWords", "()Ljava/lang/String;", "statement", "getStatement", "dao"})
    public static final class SelectPlan
    extends DefaultTableSelectPlan {
        public SelectPlan(@NotNull Table from) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            super(from);
        }

        public final boolean getNoOrderByButRowsLimited() {
            return this.getOrderBy().isEmpty() && this.getLimit() > 0;
        }

        @Override
        @NotNull
        public String getSelectWords() {
            return this.getNoOrderByButRowsLimited() ? super.getSelectWords() + " TOP " + this.getLimit() : super.getSelectWords();
        }

        @Override
        @NotNull
        public String getStatement() {
            String sql = this.getBaseSql() + this.getWhereTxt() + this.getGroupByTxt() + this.getHavingTxt() + this.getOrderByTxt();
            return this.getNoOrderByButRowsLimited() ? sql : this.getFrom().getDialect().getPagination().statement(sql, this.getLimit(), this.getOffset());
        }

        @Override
        @NotNull
        public List<Object> getParameters() {
            List<Object> havingParams;
            Condition condition = this.getWhere();
            List<Object> list = condition == null ? null : condition.getParameters();
            List<Object> params = list == null ? CollectionsKt.emptyList() : list;
            condition = this.getHaving();
            List<Object> list2 = havingParams = condition == null ? null : condition.getParameters();
            if (havingParams != null) {
                params = CollectionsKt.plus((Collection)params, (Iterable)havingParams);
            }
            return this.getNoOrderByButRowsLimited() ? params : this.getFrom().getDialect().getPagination().parameters((List<? extends Object>)params, this.getLimit(), this.getOffset());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Linstep/dao/sql/dialect/SQLServerDialect$Pagination;", "Linstep/dao/sql/dialect/StandardPagination;", "()V", "statement", "", "limit", "", "offset", "dao"})
    public static final class Pagination
    extends StandardPagination {
        @Override
        @NotNull
        public String statement(@NotNull String statement2, int limit, int offset) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            if (limit <= 0) {
                return offset > 0 ? Intrinsics.stringPlus((String)statement2, (Object)"\n OFFSET ? ROWS") : statement2;
            }
            return offset > 0 ? Intrinsics.stringPlus((String)statement2, (Object)"\nOFFSET ? ROWS\nFETCH NEXT ? ROWS ONLY") : Intrinsics.stringPlus((String)statement2, (Object)"\nOFFSET 0 ROWS\nFETCH NEXT ? ROWS ONLY");
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[IntegerColumnType.values().length];
            nArray[IntegerColumnType.Long.ordinal()] = 1;
            nArray[IntegerColumnType.Int.ordinal()] = 2;
            nArray[IntegerColumnType.Small.ordinal()] = 3;
            nArray[IntegerColumnType.Tiny.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DateTimeColumnType.values().length];
            nArray[DateTimeColumnType.DateTime.ordinal()] = 1;
            nArray[DateTimeColumnType.Instant.ordinal()] = 2;
            nArray[DateTimeColumnType.OffsetDateTime.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BinaryColumnType.values().length];
            nArray[BinaryColumnType.BLOB.ordinal()] = 1;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

