/*
 * Decompiled with CFR 0.152.
 */
package me.insidezhou.southernquiet.event.driver;

import me.insidezhou.southernquiet.FrameworkAutoConfiguration;
import me.insidezhou.southernquiet.event.EventPublisher;
import me.insidezhou.southernquiet.event.ShouldBroadcast;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractEventPublisher<E>
implements EventPublisher<E>,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;
    private String[] defaultChannel;

    public AbstractEventPublisher(FrameworkAutoConfiguration.EventProperties properties) {
        this.defaultChannel = properties.getDefaultChannels();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void publishToLocalOnly(E event) {
        this.applicationEventPublisher.publishEvent(event);
    }

    @Override
    public void publish(E event) {
        this.publishToLocalOnly(event);
        ShouldBroadcast annotation = (ShouldBroadcast)AnnotationUtils.getAnnotation(event.getClass(), ShouldBroadcast.class);
        if (null != annotation) {
            String[] channels = annotation.channels();
            if (null == channels || 0 == channels.length) {
                channels = this.defaultChannel;
            }
            this.broadcast(event, channels);
        }
    }

    protected abstract void broadcast(E var1, String[] var2);
}

